/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.painter.Painter;
import com.explodingpixels.swingx.EPPanel;
import com.explodingpixels.widgets.WindowDragger;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriAreaComponent {
    private PanelBuilder fLeftPanelBuilder = new PanelBuilder(new FormLayout("", "fill:p:grow"), new JPanel());
    private PanelBuilder fCenterPanelBuilder = new PanelBuilder(new FormLayout("", "fill:p:grow"), new JPanel());
    private PanelBuilder fRightPanelBuilder = new PanelBuilder(new FormLayout("", "fill:p:grow"), new JPanel());
    private final EPPanel fPanel = new EPPanel();
    private int fSpacer_pixels;

    TriAreaComponent() {
        this(0);
    }

    TriAreaComponent(int spacer_pixels) {
        this.fSpacer_pixels = spacer_pixels;
        FormLayout layout = new FormLayout("left:p:grow, center:p:grow, right:p:grow", "fill:p:grow");
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(layout, this.fPanel);
        builder.add((Component)this.fLeftPanelBuilder.getPanel(), cc.xy(1, 1));
        builder.add((Component)this.fCenterPanelBuilder.getPanel(), cc.xy(2, 1));
        builder.add((Component)this.fRightPanelBuilder.getPanel(), cc.xy(3, 1));
        this.fLeftPanelBuilder.getPanel().setOpaque(false);
        this.fCenterPanelBuilder.getPanel().setOpaque(false);
        this.fRightPanelBuilder.getPanel().setOpaque(false);
    }

    void forceAreasToHaveTheSameWidth() {
        ((FormLayout)this.fPanel.getLayout()).setColumnGroups(new int[][]{{1, 2, 3}});
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public void installWindowDraggerOnWindow(Window window) {
        new WindowDragger(window, this.getComponent());
    }

    public void addComponentToLeft(JComponent toolToAdd) {
        this.addComponentToLeft(toolToAdd, this.fSpacer_pixels);
    }

    public void addComponentToLeft(JComponent toolToAdd, int spacer_pixels) {
        this.fLeftPanelBuilder.appendColumn("p");
        this.fLeftPanelBuilder.add(toolToAdd);
        this.fLeftPanelBuilder.nextColumn();
        this.fLeftPanelBuilder.appendColumn("p");
        this.fLeftPanelBuilder.add(MacWidgetFactory.createSpacer(spacer_pixels, 0));
        this.fLeftPanelBuilder.nextColumn();
    }

    public void addComponentToCenter(JComponent toolToAdd) {
        this.addComponentToCenter(toolToAdd, this.fSpacer_pixels);
    }

    public void addComponentToCenter(JComponent toolToAdd, int spacer_pixels) {
        if (this.getCenterComponentCount() > 0) {
            this.fCenterPanelBuilder.appendColumn("p");
            this.fCenterPanelBuilder.add(MacWidgetFactory.createSpacer(spacer_pixels, 0));
            this.fCenterPanelBuilder.nextColumn();
        }
        this.fCenterPanelBuilder.appendColumn("p");
        this.fCenterPanelBuilder.add(toolToAdd);
        this.fCenterPanelBuilder.nextColumn();
    }

    public void addComponentToRight(JComponent toolToAdd) {
        this.addComponentToRight(toolToAdd, this.fSpacer_pixels);
    }

    public void addComponentToRight(JComponent toolToAdd, int spacer_pixels) {
        if (this.getRightComponentCount() > 0) {
            this.fRightPanelBuilder.appendColumn("p");
            this.fRightPanelBuilder.add(MacWidgetFactory.createSpacer(spacer_pixels, 0));
            this.fRightPanelBuilder.nextColumn();
        }
        this.fRightPanelBuilder.appendColumn("p");
        this.fRightPanelBuilder.add(toolToAdd);
        this.fRightPanelBuilder.nextColumn();
    }

    void setBackgroundPainter(Painter<Component> backgroundPainter) {
        this.fPanel.setBackgroundPainter(backgroundPainter);
    }

    protected final int getLeftComponentCount() {
        return this.fLeftPanelBuilder.getPanel().getComponentCount();
    }

    protected final int getCenterComponentCount() {
        return this.fCenterPanelBuilder.getPanel().getComponentCount();
    }

    protected final int getRightComponentCount() {
        return this.fRightPanelBuilder.getPanel().getComponentCount();
    }
}

