/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class LabelTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 0L;

    public LabelTableCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof JLabel) {
            JLabel labelValue = (JLabel)value;
            this.setText(labelValue.getText());
            this.setIcon(labelValue.getIcon());
        } else if (value instanceof ProtocolProviderService) {
            ProtocolProviderService pps = (ProtocolProviderService)value;
            this.setText(pps.getAccountID().getDisplayName());
        } else if (value instanceof MetaContactGroup) {
            MetaContactGroup group = (MetaContactGroup)value;
            this.setText(group.getGroupName());
        } else if (value instanceof ChatRoomProviderWrapper) {
            ChatRoomProviderWrapper provider = (ChatRoomProviderWrapper)value;
            this.setText(provider.getProtocolProvider().getAccountID().getDisplayName());
        } else {
            this.setText(value.toString());
        }
        if (isSelected) {
            this.setBackground(Constants.SELECTED_COLOR);
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
        }
        return this;
    }
}

