/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.WizardController;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.WizardEvent;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.WizardListener;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.WizardModel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.WizardPage;
import org.jitsi.service.resources.ResourceManagementService;

public class Wizard
extends SIPCommDialog
implements WindowListener,
WizardContainer,
PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    private JLabel wizardIconLabel;
    private TransparentPanel wizardIconPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    ResourceManagementService resources = GuiActivator.getResources();
    private String backButtonDefaultText = this.resources.getI18NString("service.gui.PREVIOUS");
    private String nextButtonDefaultText = this.resources.getI18NString("service.gui.NEXT");
    private String finishButtonDefaultText = this.resources.getI18NString("service.gui.FINISH");
    private String cancelButtonDefaultText = this.resources.getI18NString("service.gui.CANCEL");
    private final WizardModel wizardModel = new WizardModel();
    private WizardController wizardController;
    protected TransparentPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private final List<WizardListener> wizardListeners = new Vector<WizardListener>();
    private JLabel statusLabel = new JLabel();
    private boolean isCurrentlySigningIn = false;

    public Wizard(Dialog owner) {
        super(owner, false);
        this.initComponents();
    }

    public Wizard(Frame owner) {
        super(owner, false);
        this.initComponents();
    }

    public JDialog getDialog() {
        return this;
    }

    public void showDialog(boolean modal) {
        if (modal) {
            this.setModal(true);
        }
        this.pack();
        super.setVisible(true);
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPage(Object id, WizardPage page) {
        Object wizardForm = page.getWizardForm();
        if (wizardForm instanceof Component) {
            this.cardPanel.add((Component)wizardForm, id);
        }
        this.wizardModel.registerPage(id, page);
    }

    public void unregisterWizardPage(final Object id) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Wizard.this.unregisterWizardPage(id);
                }
            });
            return;
        }
        WizardPage wizardPage = this.wizardModel.getWizardPage(id);
        if (wizardPage != null) {
            this.cardPanel.remove((Component)this.wizardModel.getWizardPage(id).getWizardForm());
            this.wizardModel.unregisterPage(id);
        }
    }

    public boolean containsPage(Object id) {
        return this.wizardModel.getWizardPage(id) != null;
    }

    public void setCurrentPage(Object id) {
        if (id == null) {
            this.close(2);
            return;
        }
        WizardPage oldPanelDescriptor = this.wizardModel.getCurrentWizardPage();
        if (oldPanelDescriptor != null) {
            oldPanelDescriptor.pageHiding();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentWizardPage().pageShowing();
        this.cardLayout.show((Container)this.cardPanel, id.toString());
        this.wizardModel.getCurrentWizardPage().pageShown();
        this.pack();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Wizard.this.propertyChange(evt);
                }
            });
            return;
        }
        String name = evt.getPropertyName();
        if ("currentPageProperty".equals(name)) {
            this.wizardController.resetButtonsToPanelRules();
        } else if ("nextButtonTextProperty".equals(name)) {
            this.nextButton.setText(evt.getNewValue().toString());
        } else if ("backButtonTextProperty".equals(name)) {
            this.backButton.setText(evt.getNewValue().toString());
        } else if ("cancelButtonTextProperty".equals(name)) {
            this.cancelButton.setText(evt.getNewValue().toString());
        } else if ("nextButtonEnabledProperty".equals(name)) {
            this.nextButton.setEnabled((Boolean)evt.getNewValue());
        } else if ("backButtonEnabledProperty".equals(name)) {
            this.backButton.setEnabled((Boolean)evt.getNewValue());
        } else if ("cancelButtonEnabledProperty".equals(name)) {
            this.cancelButton.setEnabled((Boolean)evt.getNewValue());
        } else if ("nextButtonIconProperty".equals(name)) {
            this.nextButton.setIcon((Icon)evt.getNewValue());
        } else if ("backButtonIconProperty".equals(name)) {
            this.backButton.setIcon((Icon)evt.getNewValue());
        } else if ("cancelButtonIconProperty".equals(name)) {
            this.cancelButton.setIcon((Icon)evt.getNewValue());
        }
    }

    public boolean isBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean newValue) {
        if (!this.isCurrentlySigningIn || !newValue) {
            this.wizardModel.setBackButtonEnabled(newValue);
        }
    }

    public boolean isNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public void setNextFinishButtonEnabled(boolean newValue) {
        this.wizardModel.setNextFinishButtonEnabled(newValue);
    }

    public boolean isCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean newValue) {
        this.wizardModel.setCancelButtonEnabled(newValue);
    }

    void close(int code) {
        WizardPage oldPanelDescriptor = this.wizardModel.getCurrentWizardPage();
        if (oldPanelDescriptor != null) {
            oldPanelDescriptor.pageHiding();
        }
        this.removeWizzardIcon();
        if (code == 1) {
            this.fireWizardEvent(2);
        } else if (code == 0) {
            this.fireWizardEvent(1);
        } else if (code == 2) {
            this.fireWizardEvent(3);
        }
        this.dispose();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(this);
        TransparentPanel buttonPanel = new TransparentPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.cardPanel = new TransparentPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout((LayoutManager)this.cardLayout);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.getDialog().getRootPane().setDefaultButton(this.nextButton);
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        this.backButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.PREVIOUS"));
        this.nextButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.NEXT"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        buttonPanel.setLayout((LayoutManager)new BorderLayout());
        buttonPanel.add((Component)separator, (Object)"North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, (Object)"East");
        TransparentPanel statusPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
        statusPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        statusPanel.add(this.statusLabel);
        buttonPanel.add((Component)statusPanel, (Object)"Center");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)buttonPanel, "South");
        contentPane.add((Component)this.cardPanel, "Center");
        contentPane.add((Component)this.wizardIconPanel, "West");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close(1);
    }

    public void setWizzardIcon(BufferedImage wizardIcon) {
        this.wizardIconLabel = new JLabel();
        this.wizardIconLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), BorderFactory.createTitledBorder("")));
        this.wizardIconLabel.setIcon(new ImageIcon(wizardIcon));
        this.wizardIconPanel.removeAll();
        this.wizardIconPanel.add((Component)this.wizardIconLabel);
    }

    public void removeWizzardIcon() {
        if (this.wizardIconLabel != null) {
            this.wizardIconPanel.remove((Component)this.wizardIconLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWizardListener(WizardListener l) {
        List<WizardListener> list = this.wizardListeners;
        synchronized (list) {
            if (!this.wizardListeners.contains(l)) {
                this.wizardListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWizardListener(WizardListener l) {
        List<WizardListener> list = this.wizardListeners;
        synchronized (list) {
            this.wizardListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWizardEvent(int eventCode) {
        ArrayList<WizardListener> listeners;
        List<WizardListener> list = this.wizardListeners;
        synchronized (list) {
            listeners = new ArrayList<WizardListener>(this.wizardListeners);
        }
        WizardEvent wizardEvent = new WizardEvent(this, eventCode);
        for (WizardListener l : listeners) {
            l.wizardFinished(wizardEvent);
        }
    }

    protected void close(boolean isEscaped) {
        if (this.isCurrentlySigningIn) {
            return;
        }
        this.close(1);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public void refresh() {
        this.pack();
        this.repaint();
    }

    public String getBackButtonDefaultText() {
        return this.backButtonDefaultText;
    }

    void setBackButtonDefaultText(String backButtonDefaultText) {
        this.backButtonDefaultText = backButtonDefaultText;
    }

    public String getNextButtonDefaultText() {
        return this.nextButtonDefaultText;
    }

    void setNextButtonDefaultText(String nextButtonDefaultText) {
        this.nextButtonDefaultText = nextButtonDefaultText;
    }

    public String getFinishButtonDefaultText() {
        return this.finishButtonDefaultText;
    }

    void setFinishButtonDefaultText(String finishButtonDefaultText) {
        this.finishButtonDefaultText = finishButtonDefaultText;
    }

    public String getCancelButtonDefaultText() {
        return this.cancelButtonDefaultText;
    }

    void setCancelButtonDefaultText(String cancelButtonDefaultText) {
        this.cancelButtonDefaultText = cancelButtonDefaultText;
    }

    public void setFinishButtonText(String text) {
        this.setFinishButtonDefaultText(text);
    }

    void startCommittingPage() {
        this.isCurrentlySigningIn = true;
        this.setBackButtonEnabled(false);
        this.setCancelButtonEnabled(false);
        this.setNextFinishButtonEnabled(false);
        this.statusLabel.setText(GuiActivator.getResources().getI18NString("service.gui.CONNECTING"));
        this.setCursor(new Cursor(3));
    }

    void stopCommittingPage() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Wizard.this.stopCommittingPage();
                }
            });
            return;
        }
        this.isCurrentlySigningIn = false;
        this.statusLabel.setText("");
        this.setCursor(new Cursor(0));
        this.setBackButtonEnabled(true);
        this.setCancelButtonEnabled(true);
        this.setNextFinishButtonEnabled(true);
    }
}

