/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallInterfaceListener;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.ChooseCallAccountDialog;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChooseCallAccountPopupMenu
extends SIPCommPopupMenu
implements Skinnable {
    private static final long serialVersionUID = 0L;
    protected final JComponent invoker;
    private CallInterfaceListener callInterfaceListener;
    private UIContactImpl uiContact;

    public ChooseCallAccountPopupMenu(JComponent invoker, String contactToCall, List<ProtocolProviderService> telephonyProviders) {
        this(invoker, contactToCall, telephonyProviders, OperationSetBasicTelephony.class);
    }

    public ChooseCallAccountPopupMenu(JComponent invoker, String contactToCall, List<ProtocolProviderService> telephonyProviders, CallInterfaceListener l) {
        this(invoker, contactToCall, telephonyProviders, OperationSetBasicTelephony.class);
        this.callInterfaceListener = l;
    }

    public ChooseCallAccountPopupMenu(JComponent invoker, String contactToCall, List<ProtocolProviderService> telephonyProviders, Class<? extends OperationSet> opSetClass) {
        this.invoker = invoker;
        this.init(GuiActivator.getResources().getI18NString(this.getI18NKeyCallVia()));
        for (ProtocolProviderService provider : telephonyProviders) {
            this.addTelephonyProviderItem(provider, contactToCall, opSetClass);
        }
    }

    public ChooseCallAccountPopupMenu(JComponent invoker, List<?> telephonyObjects) {
        this(invoker, telephonyObjects, OperationSetBasicTelephony.class);
    }

    public ChooseCallAccountPopupMenu(JComponent invoker, List<?> telephonyObjects, Class<? extends OperationSet> opSetClass) {
        this.invoker = invoker;
        this.init(GuiActivator.getResources().getI18NString(this.getI18NKeyChooseContact()));
        for (Object o : telephonyObjects) {
            if (o instanceof UIContactDetailImpl) {
                this.addTelephonyContactItem((UIContactDetailImpl)o, opSetClass);
                continue;
            }
            if (!(o instanceof ChatTransport)) continue;
            this.addTelephonyChatTransportItem((ChatTransport)o, opSetClass);
        }
    }

    protected String getI18NKeyChooseContact() {
        return "service.gui.CHOOSE_CONTACT";
    }

    protected String getI18NKeyCallVia() {
        return "service.gui.CALL_VIA";
    }

    private void init(String infoString) {
        this.setInvoker(this.invoker);
        this.add(this.createInfoLabel(infoString));
        this.addSeparator();
        this.setFocusable(true);
    }

    private void addTelephonyProviderItem(ProtocolProviderService telephonyProvider, final String contactString, final Class<? extends OperationSet> opSetClass) {
        final ProviderMenuItem providerItem = new ProviderMenuItem(telephonyProvider);
        providerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChooseCallAccountPopupMenu.this.uiContact != null) {
                    ChooseCallAccountPopupMenu.this.itemSelected(opSetClass, providerItem.getProtocolProvider(), contactString, ChooseCallAccountPopupMenu.this.uiContact);
                } else {
                    ChooseCallAccountPopupMenu.this.itemSelected((Class<? extends OperationSet>)opSetClass, providerItem.getProtocolProvider(), contactString);
                }
                if (ChooseCallAccountPopupMenu.this.callInterfaceListener != null) {
                    ChooseCallAccountPopupMenu.this.callInterfaceListener.callInterfaceStarted();
                }
                ChooseCallAccountPopupMenu.this.setVisible(false);
            }
        });
        this.add(providerItem);
    }

    private void addTelephonyContactItem(final UIContactDetailImpl telephonyContact, final Class<? extends OperationSet> opSetClass) {
        ContactMenuItem contactItem = new ContactMenuItem(telephonyContact);
        contactItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List providers = AccountUtils.getOpSetRegisteredProviders((Class)opSetClass, (ProtocolProviderService)telephonyContact.getPreferredProtocolProvider(opSetClass), (String)telephonyContact.getPreferredProtocol(opSetClass));
                if (providers == null || providers.size() <= 0) {
                    new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.CALL_FAILED"), GuiActivator.getResources().getI18NString("service.gui.NO_ONLINE_TELEPHONY_ACCOUNT")).showDialog();
                    return;
                }
                if (providers.size() > 1) {
                    ChooseCallAccountPopupMenu.this.itemSelected((Class<? extends OperationSet>)opSetClass, providers, telephonyContact.getAddress());
                } else {
                    ProtocolProviderService provider = (ProtocolProviderService)providers.get(0);
                    String contactAddress = telephonyContact.getAddress();
                    if (ChooseCallAccountPopupMenu.this.uiContact != null) {
                        ChooseCallAccountPopupMenu.this.itemSelected(opSetClass, provider, contactAddress, ChooseCallAccountPopupMenu.this.uiContact);
                    } else {
                        ChooseCallAccountPopupMenu.this.itemSelected((Class<? extends OperationSet>)opSetClass, provider, contactAddress);
                    }
                }
                ChooseCallAccountPopupMenu.this.setVisible(false);
            }
        });
        String category = telephonyContact.getCategory();
        if (category != null && category.equals(ContactDetail.Category.Phone)) {
            int index = this.findPhoneItemIndex();
            if (index < 0) {
                this.add(contactItem);
            } else {
                this.insert(contactItem, this.findPhoneItemIndex());
            }
        } else {
            Component lastComp = this.getComponent(this.getComponentCount() - 1);
            if (lastComp instanceof ContactMenuItem) {
                category = ((ContactMenuItem)lastComp).getCategory();
            }
            if (category != null && category.equals(ContactDetail.Category.Phone)) {
                this.addSeparator();
            }
            this.add(contactItem);
        }
    }

    private int findPhoneItemIndex() {
        int index = -1;
        for (int i = this.getComponentCount() - 1; i > 1; --i) {
            Component c = this.getComponent(i);
            if (c instanceof ContactMenuItem) {
                String category = ((ContactMenuItem)c).getCategory();
                if (category != null && category.equals(ContactDetail.Category.Phone)) continue;
            }
            if (c instanceof JSeparator) {
                index = i - 1;
                continue;
            }
            return index;
        }
        return index;
    }

    private void addTelephonyChatTransportItem(final ChatTransport telTransport, final Class<? extends OperationSet> opSetClass) {
        ChatTransportMenuItem transportItem = new ChatTransportMenuItem(telTransport);
        transportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtocolProviderService provider = telTransport.getProtocolProvider();
                String contactAddress = telTransport.getName();
                if (ChooseCallAccountPopupMenu.this.uiContact != null) {
                    CallManager.createCall(opSetClass, provider, contactAddress, ChooseCallAccountPopupMenu.this.uiContact);
                } else {
                    CallManager.createCall(opSetClass, provider, contactAddress);
                }
                ChooseCallAccountPopupMenu.this.setVisible(false);
            }
        });
        this.add(transportItem);
    }

    public void showPopupMenu(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void showPopupMenu() {
        Point location = new Point(this.invoker.getX(), this.invoker.getY() + this.invoker.getHeight());
        SwingUtilities.convertPointToScreen(location, this.invoker.getParent());
        this.setLocation(location);
        this.setVisible(true);
    }

    public void setUIContact(UIContactImpl uiContact) {
        this.uiContact = uiContact;
    }

    private Component createInfoLabel(String infoString) {
        JMenuItem infoLabel = new JMenuItem();
        infoLabel.setEnabled(false);
        infoLabel.setFocusable(false);
        infoLabel.setText("<html><b>" + infoString + "</b></html>");
        return infoLabel;
    }

    protected void itemSelected(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProviderService, String contact, UIContactImpl uiContact) {
        CallManager.createCall(opSetClass, protocolProviderService, contact, uiContact);
    }

    protected void itemSelected(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProviderService, String contact) {
        CallManager.createCall(opSetClass, protocolProviderService, contact);
    }

    protected void itemSelected(Class<? extends OperationSet> opSetClass, List<ProtocolProviderService> providers, String contact) {
        ChooseCallAccountDialog callAccountDialog = new ChooseCallAccountDialog(contact, opSetClass, providers);
        if (this.uiContact != null) {
            callAccountDialog.setUIContact(this.uiContact);
        }
        callAccountDialog.setVisible(true);
    }

    public void loadSkin() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Skinnable)) continue;
            Skinnable skinnableComponent = (Skinnable)component;
            skinnableComponent.loadSkin();
        }
    }

    private class ChatTransportMenuItem
    extends JMenuItem
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private final ChatTransport chatTransport;

        public ChatTransportMenuItem(ChatTransport chatTransport) {
            this.chatTransport = chatTransport;
            this.setText(chatTransport.getName());
            this.loadSkin();
        }

        public void loadSkin() {
            PresenceStatus status = this.chatTransport.getStatus();
            byte[] statusIconBytes = status.getStatusIcon();
            ImageIcon statusIcon = null;
            if (statusIconBytes != null && statusIconBytes.length > 0) {
                statusIcon = ImageLoader.getIndexedProtocolIcon(ImageUtils.getBytesInImage((byte[])statusIconBytes), this.chatTransport.getProtocolProvider());
            }
            if (statusIcon != null) {
                this.setIcon(statusIcon);
            }
        }
    }

    private class ContactMenuItem
    extends JMenuItem
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private final UIContactDetailImpl contact;

        public ContactMenuItem(UIContactDetailImpl contact) {
            this.contact = contact;
            String itemName = "<html>";
            Iterator labels = contact.getLabels();
            if (labels != null && labels.hasNext()) {
                while (labels.hasNext()) {
                    itemName = itemName + "<b style=\"color: gray\">" + ((String)labels.next()).toLowerCase() + "</b> ";
                }
            }
            itemName = itemName + contact.getAddress() + "</html>";
            this.setText(itemName);
            this.loadSkin();
        }

        public String getCategory() {
            return this.contact.getCategory();
        }

        public void loadSkin() {
            ImageIcon contactIcon = this.contact.getStatusIcon();
            if (contactIcon == null) {
                PresenceStatus status = this.contact.getPresenceStatus();
                BufferedImage statusIcon = null;
                if (status != null) {
                    statusIcon = Constants.getStatusIcon(status);
                }
                if (statusIcon != null) {
                    contactIcon = ImageLoader.getIndexedProtocolIcon(statusIcon, this.contact.getPreferredProtocolProvider(null));
                }
            }
            if (contactIcon != null) {
                this.setIcon(ImageLoader.getIndexedProtocolIcon(contactIcon.getImage(), this.contact.getPreferredProtocolProvider(null)));
            }
        }
    }

    private class ProviderMenuItem
    extends JMenuItem
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private final ProtocolProviderService protocolProvider;

        public ProviderMenuItem(ProtocolProviderService protocolProvider) {
            this.protocolProvider = protocolProvider;
            this.setText(protocolProvider.getAccountID().getDisplayName());
            this.loadSkin();
        }

        public ProtocolProviderService getProtocolProvider() {
            return this.protocolProvider;
        }

        public void loadSkin() {
            byte[] protocolIcon = this.protocolProvider.getProtocolIcon().getIcon("IconSize16x16");
            if (protocolIcon != null) {
                this.setIcon(ImageLoader.getIndexedProtocolIcon(ImageUtils.getBytesInImage((byte[])protocolIcon), this.protocolProvider));
            }
        }
    }
}

