/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommBorders;
import net.java.sip.communicator.impl.gui.main.chat.history.DatesListRenderer;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;

public class DatesPanel
extends SIPCommScrollPane
implements ListSelectionListener {
    private final JList datesList = new JList();
    private final DefaultListModel listModel = new DefaultListModel();
    private final HistoryWindow historyWindow;
    private int lastSelectedIndex = -1;

    public DatesPanel(HistoryWindow historyWindow) {
        this.historyWindow = historyWindow;
        this.setPreferredSize(new Dimension(100, 100));
        this.setBorder(SIPCommBorders.getBoldRoundBorder());
        this.setOpaque(false);
        this.datesList.setModel(this.listModel);
        this.datesList.setCellRenderer(new DatesListRenderer());
        this.datesList.setFont(this.datesList.getFont().deriveFont(1));
        this.datesList.setSelectionMode(0);
        this.datesList.addListSelectionListener(this);
        TransparentPanel listPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        listPanel.add((Component)this.datesList, "North");
        this.setViewportView((Component)listPanel);
        this.getVerticalScrollBar().setUnitIncrement(30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatesNumber() {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            return this.listModel.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int index) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            return (Date)this.listModel.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getNextDate(Date date) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            int dateIndex = this.listModel.indexOf(date);
            Date nextDate = dateIndex < this.listModel.getSize() - 1 ? this.getDate(dateIndex + 1) : new Date(System.currentTimeMillis());
            return nextDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDate(Date date) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            int listSize = this.listModel.size();
            boolean dateAdded = false;
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    Date dateFromList = (Date)this.listModel.get(i);
                    if (!dateFromList.after(date)) continue;
                    this.listModel.add(i, date);
                    dateAdded = true;
                    break;
                }
                if (!dateAdded) {
                    this.listModel.addElement(date);
                }
            } else {
                this.listModel.addElement(date);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDates() {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            this.listModel.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDate(Date date) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            return this.listModel.contains(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            int selectedIndex = this.datesList.getSelectedIndex();
            if (selectedIndex != -1 && this.lastSelectedIndex != selectedIndex) {
                this.setLastSelectedIndex(selectedIndex);
                Date date = (Date)this.listModel.get(selectedIndex);
                this.historyWindow.showHistoryByPeriod(date, this.historyWindow.getNextDateFromHistory(date));
            }
        }
    }

    public void setSelected(int index) {
        this.datesList.setSelectedIndex(index);
    }

    public ListModel getModel() {
        return this.listModel;
    }

    public int getLastSelectedIndex() {
        return this.lastSelectedIndex;
    }

    public void setLastSelectedIndex(int lastSelectedIndex) {
        this.lastSelectedIndex = lastSelectedIndex;
    }
}

