/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindow;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class EditMenu
extends SIPCommMenu
implements ActionListener,
Skinnable {
    private JMenuItem fontDialogMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.FONT"));
    private JMenuItem cutMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CUT"), new ImageIcon(ImageLoader.getImage(ImageLoader.CUT_ICON)));
    private JMenuItem copyMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.COPY"), new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
    private JMenuItem pasteMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.PASTE"), new ImageIcon(ImageLoader.getImage(ImageLoader.PASTE_ICON)));
    private ChatWindow chatWindow;

    public EditMenu(ChatWindow chatWindow) {
        super(GuiActivator.getResources().getI18NString("service.gui.EDIT"));
        this.chatWindow = chatWindow;
        this.cutMenuItem.setName("cut");
        this.copyMenuItem.setName("copy");
        this.pasteMenuItem.setName("paste");
        this.cutMenuItem.addActionListener(this);
        this.copyMenuItem.addActionListener(this);
        this.pasteMenuItem.addActionListener(this);
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.add(this.pasteMenuItem);
        if (ConfigurationUtils.isFontSupportEnabled()) {
            this.addSeparator();
            this.fontDialogMenuItem.setName("font");
            this.fontDialogMenuItem.addActionListener(this);
            this.add(this.fontDialogMenuItem);
            this.fontDialogMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.FONT"));
        }
        this.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.EDIT"));
        this.cutMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CUT"));
        this.copyMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.COPY"));
        this.pasteMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.PASTE"));
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String menuItemName = menuItem.getName();
        if (menuItemName.equalsIgnoreCase("cut")) {
            this.chatWindow.getCurrentChat().cut();
        } else if (menuItemName.equalsIgnoreCase("copy")) {
            this.chatWindow.getCurrentChat().copy();
        } else if (menuItemName.equalsIgnoreCase("paste")) {
            this.chatWindow.getCurrentChat().paste();
        } else if (menuItemName.equalsIgnoreCase("font")) {
            this.chatWindow.getCurrentChat().showFontChooserDialog();
        }
    }

    public void loadSkin() {
        this.cutMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CUT_ICON)));
        this.copyMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
        this.pasteMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.PASTE_ICON)));
    }
}

