/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JList;
import javax.swing.text.Position;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatContact;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListModel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;

public class CListKeySearchListener
implements KeyListener {
    private JList contactList;
    private char lastTypedKey = (char)65535;
    private long lastTypedTimestamp = 0L;
    private StringBuffer keyBuffer = new StringBuffer();

    public CListKeySearchListener(JList contactList) {
        this.contactList = contactList;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.contactList.getModel().getSize() <= 0) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (keyCode == 37) {
            this.closeGroup();
        } else if (keyCode == 39) {
            this.openGroup();
        } else if (keyCode == 10) {
            this.openOrCloseGroup();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.contactList.getModel().getSize() <= 0) {
            return;
        }
        long eventTimestamp = e.getWhen();
        char keyChar = e.getKeyChar();
        if (keyChar == ' ') {
            this.openOrCloseGroup();
        } else if (keyChar == '+') {
            this.openGroup();
        } else if (keyChar == '-') {
            this.closeGroup();
        } else {
            if (this.lastTypedTimestamp - eventTimestamp > 1000L) {
                this.keyBuffer.delete(0, this.keyBuffer.length() - 1);
            }
            this.lastTypedTimestamp = eventTimestamp;
            this.keyBuffer.append(keyChar);
            boolean selectedSameLetterContact = false;
            int selectedIndex = this.contactList.getSelectedIndex();
            if (selectedIndex != -1) {
                String selectedContactName;
                Object selectedObject = this.contactList.getSelectedValue();
                if (selectedObject instanceof MetaContact) {
                    selectedContactName = ((MetaContact)selectedObject).getDisplayName();
                    if (selectedContactName != null) {
                        selectedSameLetterContact = selectedContactName.substring(0, 1).equalsIgnoreCase(this.keyBuffer.toString());
                    }
                } else if (selectedObject instanceof ConferenceChatContact && (selectedContactName = ((ConferenceChatContact)selectedObject).getName()) != null) {
                    selectedSameLetterContact = selectedContactName.substring(0, 1).equalsIgnoreCase(this.keyBuffer.toString());
                }
            }
            int contactIndex = this.contactList.getNextMatch(this.keyBuffer.toString(), this.lastTypedKey != keyChar || !selectedSameLetterContact ? 0 : selectedIndex + 1, Position.Bias.Forward);
            int currentlySelectedIndex = this.contactList.getSelectedIndex();
            if (currentlySelectedIndex != contactIndex && contactIndex != -1) {
                this.contactList.setSelectedIndex(contactIndex);
                currentlySelectedIndex = this.contactList.getSelectedIndex();
            }
            this.contactList.ensureIndexIsVisible(currentlySelectedIndex);
            this.lastTypedKey = keyChar;
        }
    }

    public void closeGroup() {
        Object selectedValue = this.contactList.getSelectedValue();
        if (selectedValue instanceof MetaContactGroup) {
            MetaContactGroup group = (MetaContactGroup)selectedValue;
            ContactListModel model = (ContactListModel)this.contactList.getModel();
            if (!model.isGroupClosed(group)) {
                model.closeGroup(group);
            }
        }
    }

    public void openGroup() {
        Object selectedValue = this.contactList.getSelectedValue();
        if (selectedValue instanceof MetaContactGroup) {
            MetaContactGroup group = (MetaContactGroup)selectedValue;
            ContactListModel model = (ContactListModel)this.contactList.getModel();
            if (model.isGroupClosed(group)) {
                model.openGroup(group);
            }
        }
    }

    public void openOrCloseGroup() {
        Object selectedValue = this.contactList.getSelectedValue();
        if (selectedValue instanceof MetaContactGroup) {
            MetaContactGroup group = (MetaContactGroup)selectedValue;
            ContactListModel model = (ContactListModel)this.contactList.getModel();
            if (model.isGroupClosed(group)) {
                model.openGroup(group);
            } else {
                model.closeGroup(group);
            }
        }
    }
}

