/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.utils.SMSManager;
import net.java.sip.communicator.plugin.desktoputil.plaf.SearchFieldUI;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;
import net.java.sip.communicator.util.skin.Skinnable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ContactSearchFieldUI
extends SearchFieldUI
implements Skinnable {
    private static final Logger logger = Logger.getLogger(ContactSearchFieldUI.class);
    private boolean isCallButtonEnabled = true;
    private boolean isSmsButtonEnabled = false;
    private ProtocolProviderRegistrationStateListener providerRegistrationStateListener = new ProtocolProviderRegistrationStateListener();
    private List<ProtocolProviderService> providers = new LinkedList<ProtocolProviderService>();
    private ProtocolProviderRegListener providerRegListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new ContactSearchFieldUI();
    }

    public ContactSearchFieldUI() {
        String callButtonEnabledString = UtilActivator.getResources().getSettingsString("impl.gui.CALL_BUTTON_ENABLED");
        if (callButtonEnabledString != null && callButtonEnabledString.length() > 0) {
            this.setCallButtonEnabled(!Boolean.parseBoolean(callButtonEnabledString));
        }
        this.loadSkin();
    }

    public void setupListeners() {
        this.providerRegListener = new ProtocolProviderRegListener();
        try {
            GuiActivator.bundleContext.addServiceListener((ServiceListener)this.providerRegListener, "(objectclass=" + ProtocolProviderService.class.getName() + ")");
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)e);
            return;
        }
        for (ProtocolProviderFactory providerFactory : GuiActivator.getProtocolProviderFactories().values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                ProtocolProviderService pps = (ProtocolProviderService)GuiActivator.bundleContext.getService(providerFactory.getProviderForAccount(accountID));
                this.providers.add(pps);
                pps.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.providerRegistrationStateListener);
            }
        }
        this.setCallButtonEnabled(this.isCallButtonEnabled);
    }

    public void setCallButtonEnabled(boolean isEnabled) {
        this.isCallButtonEnabled = isEnabled;
        super.setCallButtonEnabled(isEnabled && CallManager.getTelephonyProviders().size() > 0);
    }

    public void setSMSButtonEnabled(boolean isEnabled) {
        this.isSmsButtonEnabled = isEnabled;
    }

    protected void customPaintBackground(Graphics g) {
        if (this.isSmsButtonEnabled) {
            super.setSMSButtonEnabled(GuiActivator.getUIService().getMainFrame().hasOperationSet(OperationSetSmsMessaging.class));
        }
        super.customPaintBackground(g);
    }

    protected void updateIcon(MouseEvent ev) {
        super.updateIcon(ev);
        if (ev.getID() == 500) {
            int x = ev.getX();
            int y = ev.getY();
            if (this.isCallIconVisible && this.getCallButtonRect().contains(x, y)) {
                JTextComponent c = this.getComponent();
                String searchText = c.getText();
                if (searchText != null) {
                    CallManager.createCall(searchText, c);
                }
            } else if (this.isSMSIconVisible && this.getSMSButtonRect().contains(x, y)) {
                JTextComponent c = this.getComponent();
                String searchText = c.getText();
                if (searchText == null) {
                    return;
                }
                SMSManager.sendSMS(this.getComponent(), searchText);
            }
        }
    }

    public void removeListeners() {
        if (this.providerRegListener != null) {
            GuiActivator.bundleContext.removeServiceListener((ServiceListener)this.providerRegListener);
            this.providerRegListener = null;
        }
        if (this.providers.size() != 0 && this.providerRegistrationStateListener != null) {
            for (ProtocolProviderService pps : this.providers) {
                pps.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.providerRegistrationStateListener);
            }
            this.providerRegistrationStateListener = null;
        }
    }

    private class ProtocolProviderRegistrationStateListener
    implements RegistrationStateChangeListener {
        private ProtocolProviderRegistrationStateListener() {
        }

        public void registrationStateChanged(final RegistrationStateChangeEvent evt) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProtocolProviderRegistrationStateListener.this.registrationStateChanged(evt);
                    }
                });
                return;
            }
            ContactSearchFieldUI.this.setCallButtonEnabled(ContactSearchFieldUI.this.isCallButtonEnabled);
        }
    }

    private class ProtocolProviderRegListener
    implements ServiceListener {
        private ProtocolProviderRegListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            ProtocolProviderService pps = (ProtocolProviderService)GuiActivator.bundleContext.getService(serviceRef);
            switch (event.getType()) {
                case 1: {
                    ContactSearchFieldUI.this.providers.add(pps);
                    pps.addRegistrationStateChangeListener((RegistrationStateChangeListener)ContactSearchFieldUI.this.providerRegistrationStateListener);
                    break;
                }
                case 4: {
                    ContactSearchFieldUI.this.providers.remove(pps);
                    pps.removeRegistrationStateChangeListener((RegistrationStateChangeListener)ContactSearchFieldUI.this.providerRegistrationStateListener);
                }
            }
        }
    }
}

