/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.gui.event.ContactListEvent;
import net.java.sip.communicator.service.gui.event.ContactListListener;
import net.java.sip.communicator.service.protocol.OperationSet;

public class ShowMoreContact
extends UIContactImpl
implements ContactListListener {
    private final String showMoreString = GuiActivator.getResources().getI18NString("service.gui.SHOW_MORE");
    private UIGroup parentGroup;
    private ContactNode contactNode;
    private final ContactQuery contactQuery;
    private final List<SourceContact> queryResults;
    private int shownResultsCount;
    private int maxResultCount;

    public ShowMoreContact(ContactQuery contactQuery, List<SourceContact> queryResults, int maxResultCount) {
        this.contactQuery = contactQuery;
        this.queryResults = queryResults;
        this.maxResultCount = maxResultCount;
        this.shownResultsCount = maxResultCount;
        GuiActivator.getContactList().addContactListListener(this);
    }

    public Object getDescriptor() {
        return this.showMoreString;
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    public String getDisplayDetails() {
        return null;
    }

    public int getSourceIndex() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ImageIcon getScaledAvatar(boolean isSelected, int width, int height) {
        return null;
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    public ExtendedTooltip getToolTip() {
        ExtendedTooltip tooltip = new ExtendedTooltip(false);
        tooltip.setTitle(GuiActivator.getResources().getI18NString("service.gui.SHOW_MORE_TOOLTIP"));
        return tooltip;
    }

    public JPopupMenu getRightButtonMenu() {
        return null;
    }

    public UIGroup getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(UIGroup parentGroup) {
        this.parentGroup = parentGroup;
    }

    public Iterator<String> getSearchStrings() {
        return null;
    }

    @Override
    public ContactNode getContactNode() {
        return this.contactNode;
    }

    @Override
    public void setContactNode(ContactNode contactNode) {
        this.contactNode = contactNode;
        if (contactNode == null) {
            GuiActivator.getContactList().removeContactListListener(this);
        }
    }

    public UIContactDetail getDefaultContactDetail(Class<? extends OperationSet> opSetClass) {
        return null;
    }

    public List<UIContactDetail> getContactDetails() {
        return null;
    }

    public List<UIContactDetail> getContactDetailsForOperationSet(Class<? extends OperationSet> opSetClass) {
        return null;
    }

    public void contactClicked(ContactListEvent evt) {
        if (evt.getSourceContact().equals((Object)this)) {
            ArrayList<SourceContact> contacts = new ArrayList<SourceContact>(this.queryResults);
            int newCount = this.shownResultsCount + this.maxResultCount;
            int resultSize = contacts.size();
            int maxCount = resultSize > newCount ? newCount : resultSize;
            GuiActivator.getContactList().removeContact(this);
            for (int i = this.shownResultsCount; i < maxCount; ++i) {
                GuiActivator.getContactList().contactReceived(new ContactReceivedEvent(this.contactQuery, (SourceContact)contacts.get(i)));
            }
            this.shownResultsCount = maxCount;
            if (this.shownResultsCount < resultSize || this.contactQuery.getStatus() != 0 && this.contactQuery.getStatus() != 2) {
                GuiActivator.getContactList().addContact(this.contactQuery, (UIContact)this, GuiActivator.getContactList().getContactSource(this.contactQuery.getContactSource()).getUIGroup(), false);
                GuiActivator.getContactList().addContactListListener(this);
            }
        }
    }

    public void groupClicked(ContactListEvent evt) {
    }

    public void groupSelected(ContactListEvent evt) {
    }

    public void contactSelected(ContactListEvent evt) {
    }

    public Collection<SIPCommButton> getContactCustomActionButtons() {
        return null;
    }
}

