/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListSearchKeyDispatcher;
import net.java.sip.communicator.impl.gui.main.contactlist.InviteUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.SearchField;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.impl.gui.utils.InviteContactListFilter;
import net.java.sip.communicator.impl.gui.utils.InviteContactTransferHandler;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListContainer;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.event.ContactListEvent;
import net.java.sip.communicator.service.gui.event.ContactListListener;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.skin.Skinnable;

public class InviteDialog
extends SIPCommDialog
implements Skinnable,
ContactListContainer {
    private static final long serialVersionUID = 0L;
    private final JTextArea reasonArea = new JTextArea();
    protected final JButton inviteButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.INVITE"));
    private final JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private final SearchField searchField;
    protected ContactList srcContactList;
    protected ContactList destContactList;
    private InviteContactTransferHandler inviteContactTransferHandler;
    private ProtocolProviderService currentProvider;
    private final JLabel iconLabel;
    protected final JTextArea infoTextArea;

    public InviteDialog(String title, boolean enableReason) {
        this.setModal(false);
        this.setTitle(title);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        TransparentPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        mainPanel.setPreferredSize(new Dimension(450, 350));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.infoTextArea = new JTextArea();
        this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.INVITE_CONTACT_MSG"));
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setEditable(false);
        this.iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.INVITE_DIALOG_ICON)));
        northPanel.add((Component)this.iconLabel, (Object)"West");
        northPanel.add((Component)this.infoTextArea, (Object)"Center");
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        buttonsPanel.add((Component)this.inviteButton);
        buttonsPanel.add((Component)this.cancelButton);
        this.inviteButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.INVITE"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        Component contactListComponent = this.createSrcContactListComponent();
        InviteContactListFilter inviteFilter = new InviteContactListFilter(this.srcContactList);
        this.srcContactList.setDefaultFilter((ContactListFilter)inviteFilter);
        this.searchField = new SearchField(null, inviteFilter, false, false);
        this.searchField.setPreferredSize(new Dimension(200, 25));
        this.searchField.setContactList(this.srcContactList);
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                InviteDialog.this.srcContactList.removeSelection();
            }
        });
        TransparentPanel leftPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        leftPanel.add((Component)((Object)this.searchField), (Object)"North");
        leftPanel.add(contactListComponent);
        JPanel listPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        listPanel.setPreferredSize(new Dimension(400, 200));
        listPanel.add((Component)leftPanel);
        listPanel.add(this.createDestContactListComponent());
        listPanel.setOpaque(false);
        JPanel addRemoveButtonsPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        addRemoveButtonsPanel.setOpaque(false);
        JButton addContactButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ADD"));
        JButton removeContactButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.REMOVE"));
        addRemoveButtonsPanel.add(addContactButton);
        addRemoveButtonsPanel.add(removeContactButton);
        addContactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedContacts = InviteDialog.this.srcContactList.getSelectedContacts();
                if (selectedContacts != null && selectedContacts.size() > 0) {
                    InviteDialog.this.moveContactsFromLeftToRight(selectedContacts.iterator());
                }
            }
        });
        removeContactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedContacts = InviteDialog.this.destContactList.getSelectedContacts();
                if (selectedContacts != null && selectedContacts.size() > 0) {
                    InviteDialog.this.moveContactsFromRightToLeft(selectedContacts.iterator());
                }
            }
        });
        TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        centerPanel.add((Component)listPanel, (Object)"Center");
        centerPanel.add((Component)addRemoveButtonsPanel, (Object)"South");
        TransparentPanel southPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        southPanel.add((Component)buttonsPanel, (Object)"South");
        if (enableReason) {
            this.reasonArea.setBorder(BorderFactory.createTitledBorder(GuiActivator.getResources().getI18NString("service.gui.INVITE_REASON")));
            southPanel.add((Component)this.reasonArea, (Object)"Center");
        }
        mainPanel.add((Component)northPanel, (Object)"North");
        mainPanel.add((Component)centerPanel, (Object)"Center");
        mainPanel.add((Component)southPanel, (Object)"South");
        this.getContentPane().add((Component)mainPanel);
        this.initTransferHandler();
        KeyboardFocusManager keyManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        ContactListSearchKeyDispatcher clKeyDispatcher = new ContactListSearchKeyDispatcher(keyManager, this.searchField, this);
        clKeyDispatcher.setContactList(this.srcContactList);
        keyManager.addKeyEventDispatcher(clKeyDispatcher);
    }

    public String getReason() {
        return this.reasonArea.getText();
    }

    public void addInviteButtonListener(ActionListener l) {
        this.inviteButton.addActionListener(l);
    }

    public void addCancelButtonListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    protected void setCurrentProvider(ProtocolProviderService protocolProvider) {
        this.currentProvider = protocolProvider;
        this.inviteContactTransferHandler.setBackupProvider(this.currentProvider);
    }

    private void moveContactsFromLeftToRight(Iterator<UIContact> contacts) {
        while (contacts.hasNext()) {
            this.moveContactFromLeftToRight(contacts.next());
        }
    }

    protected void moveContactFromLeftToRight(UIContact uiContact) {
        this.destContactList.addContact((UIContact)new InviteUIContact(uiContact, this.currentProvider), null, false, false);
    }

    protected void moveContactsFromRightToLeft(Iterator<UIContact> contacts) {
        while (contacts.hasNext()) {
            this.moveContactFromRightToLeft(contacts.next());
        }
    }

    private void moveContactFromRightToLeft(UIContact uiContact) {
        this.destContactList.removeContact(uiContact);
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.INVITE_DIALOG_ICON)));
    }

    private Component createSrcContactListComponent() {
        this.srcContactList = GuiActivator.getUIService().createContactListComponent(this);
        this.srcContactList.setDragEnabled(true);
        this.srcContactList.setRightButtonMenuEnabled(false);
        this.srcContactList.setContactButtonsVisible(false);
        this.srcContactList.setMultipleSelectionEnabled(true);
        this.srcContactList.addContactListListener(new ContactListListener(){

            public void groupSelected(ContactListEvent evt) {
            }

            public void groupClicked(ContactListEvent evt) {
            }

            public void contactSelected(ContactListEvent evt) {
            }

            public void contactClicked(ContactListEvent evt) {
                if (evt.getClickCount() > 1) {
                    InviteDialog.this.moveContactFromLeftToRight(evt.getSourceContact());
                }
            }
        });
        JScrollPane contactListScrollPane = new JScrollPane();
        contactListScrollPane.setOpaque(false);
        contactListScrollPane.getViewport().setOpaque(false);
        contactListScrollPane.getViewport().add(this.srcContactList.getComponent());
        contactListScrollPane.getViewport().setBorder(null);
        contactListScrollPane.setViewportBorder(null);
        contactListScrollPane.setBorder(null);
        return contactListScrollPane;
    }

    private Component createDestContactListComponent() {
        this.destContactList = GuiActivator.getUIService().createContactListComponent(this);
        this.destContactList.removeAllContactSources();
        this.destContactList.setContactButtonsVisible(false);
        this.destContactList.setRightButtonMenuEnabled(false);
        this.destContactList.setMultipleSelectionEnabled(true);
        this.destContactList.addContactListListener(new ContactListListener(){

            public void groupSelected(ContactListEvent evt) {
            }

            public void groupClicked(ContactListEvent evt) {
            }

            public void contactSelected(ContactListEvent evt) {
            }

            public void contactClicked(ContactListEvent evt) {
                if (evt.getClickCount() > 1) {
                    InviteDialog.this.moveContactFromRightToLeft(evt.getSourceContact());
                }
            }
        });
        JScrollPane contactListScrollPane = new JScrollPane();
        contactListScrollPane.setOpaque(false);
        contactListScrollPane.getViewport().setOpaque(false);
        contactListScrollPane.getViewport().add(this.destContactList.getComponent());
        contactListScrollPane.getViewport().setBorder(null);
        contactListScrollPane.setViewportBorder(null);
        contactListScrollPane.setBorder(null);
        return contactListScrollPane;
    }

    public void enterKeyTyped() {
        List selectedContacts = this.srcContactList.getSelectedContacts();
        if (selectedContacts == null) {
            return;
        }
        this.moveContactsFromLeftToRight(selectedContacts.iterator());
    }

    public void ctrlEnterKeyTyped() {
    }

    private void initTransferHandler() {
        this.inviteContactTransferHandler = new InviteContactTransferHandler(this.destContactList, 1, true);
        InviteContactTransferHandler srcContactTransferHandler = new InviteContactTransferHandler(this.srcContactList, 0, true);
        if (this.srcContactList.getComponent() instanceof JComponent) {
            ((JComponent)this.srcContactList).setTransferHandler((TransferHandler)((Object)srcContactTransferHandler));
        }
        if (this.destContactList.getComponent() instanceof JComponent) {
            ((JComponent)this.destContactList).setTransferHandler((TransferHandler)((Object)this.inviteContactTransferHandler));
        }
    }

    public String getCurrentSearchText() {
        return this.searchField.getText();
    }

    public void clearCurrentSearchText() {
        this.searchField.setText("");
    }

    public boolean isMenuSelected() {
        return false;
    }

    public void dispose() {
        this.searchField.dispose();
        super.dispose();
    }
}

