/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;

public class BasicCachingControl
implements CachingControl {
    private static final String PAUSEMESSAGE = "Pause";
    private static final String RESUMEMESSAGE = "Resume";
    private boolean isDownloading;
    private boolean isPaused;
    private long length;
    private long progress;
    private JProgressBar progressBar;
    private JButton pauseButton;
    private AbstractController controller;

    public BasicCachingControl(AbstractController c, long length) {
        this.controller = c;
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.pauseButton = new JButton(PAUSEMESSAGE);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String label = BasicCachingControl.this.pauseButton.getText();
                if (BasicCachingControl.this.isPaused()) {
                    BasicCachingControl.this.pauseButton.setText(BasicCachingControl.PAUSEMESSAGE);
                    BasicCachingControl.this.setPaused(false);
                } else {
                    BasicCachingControl.this.pauseButton.setText(BasicCachingControl.RESUMEMESSAGE);
                    BasicCachingControl.this.setPaused(true);
                }
                BasicCachingControl.this.pauseButton.getParent().validate();
            }
        });
        this.reset(length);
        this.controller.addControl(this);
    }

    public void addToProgress(long toAdd) {
        this.setContentProgress(this.progress + toAdd);
    }

    public synchronized void blockWhilePaused() {
        while (this.isPaused) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public long getContentProgress() {
        return this.progress;
    }

    @Override
    public Component getControlComponent() {
        return this.pauseButton;
    }

    @Override
    public Component getProgressBarComponent() {
        return this.progressBar;
    }

    @Override
    public boolean isDownloading() {
        return this.isDownloading;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public synchronized void reset(long length) {
        this.length = length;
        this.progress = 0L;
        this.progressBar.setValue(0);
        this.setContentLength(length);
        this.setDownLoading(false);
        this.setPaused(false);
        this.controller.postEvent(new CachingControlEvent(this.controller, this, this.progress));
    }

    public synchronized void setContentLength(long length) {
        this.length = length;
        if (length == Long.MAX_VALUE) {
            this.progressBar.setMaximum(0);
        } else {
            this.progressBar.setMaximum((int)length);
        }
    }

    public synchronized void setContentProgress(long progress) {
        this.blockWhilePaused();
        this.progress = progress;
        this.setDownLoading(progress < this.length);
        this.progressBar.setValue((int)progress);
        this.controller.postEvent(new CachingControlEvent(this.controller, this, progress));
    }

    public void setDone() {
        this.setContentProgress(this.length);
    }

    public void setDownLoading(boolean isDownloading) {
        this.isDownloading = isDownloading;
        if (!isDownloading) {
            this.setPaused(false);
        }
    }

    protected synchronized void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
        this.notifyAll();
    }
}

