/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.StopTimeSetError;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import net.sf.fmj.media.Log;

public class BasicClock
implements Clock {
    private TimeBase master;
    private long startTime = Long.MAX_VALUE;
    private long stopTime = Long.MAX_VALUE;
    private long mediaTime = 0L;
    private long mediaStart = 0L;
    private long mediaLength = -1L;
    private float rate = 1.0f;
    public static final int STOPPED = 0;
    public static final int STARTED = 1;

    public BasicClock() {
        this.master = new SystemTimeBase();
    }

    @Override
    public long getMediaNanoseconds() {
        if (this.getState() == 0) {
            return this.mediaTime;
        }
        long now = this.master.getNanoseconds();
        if (now > this.startTime) {
            long t = (long)((double)(now - this.startTime) * (double)this.rate) + this.mediaTime;
            if (this.mediaLength != -1L && t > this.mediaStart + this.mediaLength) {
                return this.mediaStart + this.mediaLength;
            }
            return t;
        }
        return this.mediaTime;
    }

    @Override
    public Time getMediaTime() {
        return new Time(this.getMediaNanoseconds());
    }

    @Override
    public float getRate() {
        return this.rate;
    }

    public int getState() {
        if (this.startTime == Long.MAX_VALUE) {
            return 0;
        }
        if (this.stopTime == Long.MAX_VALUE) {
            return 1;
        }
        return 1;
    }

    @Override
    public Time getStopTime() {
        return new Time(this.stopTime);
    }

    @Override
    public Time getSyncTime() {
        return new Time(0L);
    }

    @Override
    public TimeBase getTimeBase() {
        return this.master;
    }

    @Override
    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        if (this.getState() == 0) {
            ClockStoppedException e = new ClockStoppedException();
            Log.dumpStack(e);
            throw e;
        }
        return new Time((long)((float)(t.getNanoseconds() - this.mediaTime) / this.rate) + this.startTime);
    }

    protected void setMediaLength(long t) {
        this.mediaLength = t;
    }

    protected void setMediaStart(long t) {
        this.mediaStart = t;
    }

    @Override
    public void setMediaTime(Time now) {
        long t;
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("setMediaTime() cannot be used on a started clock."));
        }
        this.mediaTime = (t = now.getNanoseconds()) < this.mediaStart ? this.mediaStart : (this.mediaLength != -1L && t > this.mediaStart + this.mediaLength ? this.mediaStart + this.mediaLength : t);
    }

    @Override
    public float setRate(float factor) {
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("setRate() cannot be used on a started clock."));
        }
        this.rate = factor;
        return this.rate;
    }

    @Override
    public void setStopTime(Time t) {
        if (this.getState() == 1 && this.stopTime != Long.MAX_VALUE) {
            this.throwError(new StopTimeSetError("setStopTime() may be set only once on a Started Clock"));
        }
        this.stopTime = t.getNanoseconds();
    }

    @Override
    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("setTimeBase cannot be used on a started clock."));
        }
        if (master == null) {
            if (!(this.master instanceof SystemTimeBase)) {
                this.master = new SystemTimeBase();
            }
        } else {
            this.master = master;
        }
    }

    @Override
    public void stop() {
        if (this.getState() == 0) {
            return;
        }
        this.mediaTime = this.getMediaNanoseconds();
        this.startTime = Long.MAX_VALUE;
    }

    @Override
    public void syncStart(Time tbt) {
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("syncStart() cannot be used on an already started clock."));
        }
        this.startTime = this.master.getNanoseconds() > tbt.getNanoseconds() ? this.master.getNanoseconds() : tbt.getNanoseconds();
    }

    protected void throwError(Error e) {
        Log.dumpStack(e);
        throw e;
    }
}

