/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.io.IOException;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.NotRealizedError;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import net.sf.fmj.media.BasicPlayer;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.control.ProgressControl;

public class MediaPlayer
extends BasicPlayer {
    protected PlaybackEngine engine = new PlaybackEngine(this);

    @Override
    protected boolean audioEnabled() {
        return this.engine.audioEnabled();
    }

    @Override
    public GainControl getGainControl() {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot get gain control on an unrealized player"));
        }
        return this.engine.getGainControl();
    }

    @Override
    protected TimeBase getMasterTimeBase() {
        return this.engine.getTimeBase();
    }

    @Override
    public long getMediaNanoseconds() {
        if (this.controllerList.size() > 1) {
            return super.getMediaNanoseconds();
        }
        return this.engine.getMediaNanoseconds();
    }

    @Override
    public Time getMediaTime() {
        if (this.controllerList.size() > 1) {
            return super.getMediaTime();
        }
        return this.engine.getMediaTime();
    }

    @Override
    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.engine.getVisualComponent();
    }

    public void setProgressControl(ProgressControl p) {
        this.engine.setProgressControl(p);
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        this.engine.setSource(source);
        this.manageController(this.engine);
        super.setSource(source);
    }

    @Override
    public void updateStats() {
        this.engine.updateRates();
    }

    @Override
    protected boolean videoEnabled() {
        return this.engine.videoEnabled();
    }
}

