/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.BufferQueueInputStream;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.FormatUtils;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.LoggingStringUtils;

public class JavaSoundCodec
extends AbstractCodec {
    private static final Logger logger = LoggerSingleton.logger;
    private BufferQueueInputStream bufferQueueInputStream;
    private volatile AudioInputStream audioInputStream;
    private volatile AudioInputStream audioInputStreamConverted;
    private AudioInputStreamThread audioInputStreamThread;
    private boolean trace;
    private int totalIn;
    private int totalOut;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    private static final int SIZEOF_SHORT = 2;
    private static final int BITS_PER_BYTE = 8;
    private static final int MAX_SIGNED_BYTE = 127;
    private static final int MAX_BYTE = 255;
    private static final int MAX_BYTE_PLUS1 = 256;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] createAuHeader(javax.sound.sampled.AudioFormat f) {
        int encoding;
        byte[] result = new byte[24];
        JavaSoundCodec.encodeIntBE(779316836, result, 0);
        JavaSoundCodec.encodeIntBE(result.length, result, 4);
        JavaSoundCodec.encodeIntBE(-1, result, 8);
        if (f.getEncoding() == AudioFormat.Encoding.ALAW) {
            if (f.getSampleSizeInBits() != 8) return null;
            encoding = 27;
        } else if (f.getEncoding() == AudioFormat.Encoding.ULAW) {
            if (f.getSampleSizeInBits() != 8) return null;
            encoding = 1;
        } else if (f.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            if (f.getSampleSizeInBits() == 8) {
                encoding = 2;
            } else if (f.getSampleSizeInBits() == 16) {
                encoding = 3;
            } else if (f.getSampleSizeInBits() == 24) {
                encoding = 4;
            } else {
                if (f.getSampleSizeInBits() != 32) return null;
                encoding = 5;
            }
            if (f.getSampleSizeInBits() > 8 && !f.isBigEndian()) {
                return null;
            }
        } else {
            if (f.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) return null;
            return null;
        }
        JavaSoundCodec.encodeIntBE(encoding, result, 12);
        if (f.getSampleRate() < 0.0f) {
            return null;
        }
        JavaSoundCodec.encodeIntBE((int)f.getSampleRate(), result, 16);
        if (f.getChannels() < 0) {
            return null;
        }
        JavaSoundCodec.encodeIntBE(f.getChannels(), result, 20);
        return result;
    }

    public static byte[] createWavHeader(javax.sound.sampled.AudioFormat f) {
        if (f.getEncoding() != AudioFormat.Encoding.PCM_SIGNED && f.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) {
            return null;
        }
        if (f.getSampleSizeInBits() == 8 && f.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) {
            return null;
        }
        if (f.getSampleSizeInBits() == 16 && f.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            return null;
        }
        byte[] result = new byte[44];
        if (f.getSampleSizeInBits() > 8 && f.isBigEndian()) {
            JavaSoundCodec.encodeIntBE(1380533848, result, 0);
        } else {
            JavaSoundCodec.encodeIntBE(1380533830, result, 0);
        }
        int len = Integer.MAX_VALUE;
        JavaSoundCodec.encodeIntLE(len + result.length - 8, result, 4);
        JavaSoundCodec.encodeIntBE(1463899717, result, 8);
        JavaSoundCodec.encodeIntBE(1718449184, result, 12);
        JavaSoundCodec.encodeIntLE(16, result, 16);
        JavaSoundCodec.encodeShortLE((short)1, result, 20);
        JavaSoundCodec.encodeShortLE((short)f.getChannels(), result, 22);
        JavaSoundCodec.encodeIntLE((int)f.getSampleRate(), result, 24);
        JavaSoundCodec.encodeIntLE((int)f.getSampleRate() * f.getChannels() * f.getSampleSizeInBits() / 8, result, 28);
        JavaSoundCodec.encodeShortLE((short)(f.getChannels() * f.getSampleSizeInBits() / 8), result, 32);
        JavaSoundCodec.encodeShortLE((short)f.getSampleSizeInBits(), result, 34);
        JavaSoundCodec.encodeIntBE(1684108385, result, 36);
        JavaSoundCodec.encodeIntLE(len, result, 40);
        return result;
    }

    private static void encodeIntBE(int value, byte[] ba, int offset) {
        int length = 4;
        for (int i = 0; i < length; ++i) {
            int byteValue = value & 0xFF;
            if (byteValue > 127) {
                byteValue -= 256;
            }
            ba[offset + (length - i - 1)] = (byte)byteValue;
            value >>= 8;
        }
    }

    private static void encodeIntLE(int value, byte[] ba, int offset) {
        int length = 4;
        for (int i = 0; i < length; ++i) {
            int byteValue = value & 0xFF;
            if (byteValue > 127) {
                byteValue -= 256;
            }
            ba[offset + i] = (byte)byteValue;
            value >>= 8;
        }
    }

    public static void encodeShortBE(short value, byte[] ba, int offset) {
        int length = 2;
        for (int i = 0; i < length; ++i) {
            int byteValue = value & 0xFF;
            if (byteValue > 127) {
                byteValue -= 256;
            }
            ba[offset + (length - i - 1)] = (byte)byteValue;
            value = (short)(value >> 8);
        }
    }

    public static void encodeShortLE(short value, byte[] ba, int offset) {
        int length = 2;
        for (int i = 0; i < length; ++i) {
            int byteValue = value & 0xFF;
            if (byteValue > 127) {
                byteValue -= 256;
            }
            ba[offset + i] = (byte)byteValue;
            value = (short)(value >> 8);
        }
    }

    private static byte[] fakeHeader(javax.sound.sampled.AudioFormat f) {
        Class<?> classVorbisAudioFormat = null;
        Class<?> classMpegAudioFormatt = null;
        if (!JavaSoundUtils.onlyStandardFormats) {
            try {
                classMpegAudioFormatt = Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFormat");
                classVorbisAudioFormat = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisAudioFormat");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != classMpegAudioFormatt && classMpegAudioFormatt.isInstance(f)) {
            return new byte[0];
        }
        if (null != classVorbisAudioFormat && classVorbisAudioFormat.isInstance(f)) {
            return new byte[0];
        }
        byte[] result = JavaSoundCodec.createAuHeader(f);
        if (result != null) {
            return result;
        }
        result = JavaSoundCodec.createWavHeader(f);
        if (result != null) {
            return result;
        }
        return null;
    }

    public JavaSoundCodec() {
        Vector<AudioFormat> formats = new Vector<AudioFormat>();
        formats.add(new AudioFormat("ULAW"));
        formats.add(new AudioFormat("alaw"));
        formats.add(new AudioFormat("LINEAR"));
        if (!JavaSoundUtils.onlyStandardFormats) {
            int i;
            try {
                Class<?> classMpegEncoding = Class.forName("javazoom.spi.mpeg.sampled.file.MpegEncoding");
                String[] mpegEncodingStrings = new String[]{"MPEG1L1", "MPEG1L2", "MPEG1L3", "MPEG2DOT5L1", "MPEG2DOT5L2", "MPEG2DOT5L3", "MPEG2L1", "MPEG2L2", "MPEG2L3"};
                for (i = 0; i < mpegEncodingStrings.length; ++i) {
                    formats.add(new AudioFormat(mpegEncodingStrings[i]));
                }
            }
            catch (Exception classMpegEncoding) {
                // empty catch block
            }
            try {
                Class<?> classVorbisEncoding = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisEncoding");
                String[] vorbisEncodingStrings = new String[]{"VORBISENC"};
                for (i = 0; i < vorbisEncodingStrings.length; ++i) {
                    formats.add(new AudioFormat(vorbisEncodingStrings[i]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inputFormats = new Format[formats.size()];
        formats.toArray(this.inputFormats);
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        int i;
        javax.sound.sampled.AudioFormat[] targetsSpecial;
        javax.sound.sampled.AudioFormat decodedFormat;
        if (input == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        javax.sound.sampled.AudioFormat javaSoundFormat = JavaSoundUtils.convertFormat((AudioFormat)input);
        javax.sound.sampled.AudioFormat[] targets1 = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_UNSIGNED, javaSoundFormat);
        javax.sound.sampled.AudioFormat[] targets2 = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, javaSoundFormat);
        Class<?> classVorbisAudioFormat = null;
        Class<?> classMpegAudioFormatt = null;
        if (!JavaSoundUtils.onlyStandardFormats) {
            try {
                classMpegAudioFormatt = Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFormat");
                classVorbisAudioFormat = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisAudioFormat");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != classMpegAudioFormatt && classMpegAudioFormatt.isInstance(javaSoundFormat)) {
            decodedFormat = new javax.sound.sampled.AudioFormat(AudioFormat.Encoding.PCM_SIGNED, javaSoundFormat.getSampleRate(), 16, javaSoundFormat.getChannels(), javaSoundFormat.getChannels() * 2, javaSoundFormat.getSampleRate(), false);
            targetsSpecial = new javax.sound.sampled.AudioFormat[]{decodedFormat};
        } else if (null != classVorbisAudioFormat && classVorbisAudioFormat.isInstance(javaSoundFormat)) {
            decodedFormat = new javax.sound.sampled.AudioFormat(AudioFormat.Encoding.PCM_SIGNED, javaSoundFormat.getSampleRate(), 16, javaSoundFormat.getChannels(), javaSoundFormat.getChannels() * 2, javaSoundFormat.getSampleRate(), false);
            targetsSpecial = new javax.sound.sampled.AudioFormat[]{decodedFormat};
        } else {
            targetsSpecial = new javax.sound.sampled.AudioFormat[]{};
        }
        Format[] result = new Format[targets1.length + targets2.length + targetsSpecial.length];
        for (i = 0; i < targets1.length; ++i) {
            result[i] = JavaSoundUtils.convertFormat(targets1[i]);
            logger.finer("getSupportedOutputFormats: " + result[i]);
        }
        for (i = 0; i < targets2.length; ++i) {
            result[targets1.length + i] = JavaSoundUtils.convertFormat(targets2[i]);
            logger.finer("getSupportedOutputFormats: " + result[targets1.length + i]);
        }
        for (i = 0; i < targetsSpecial.length; ++i) {
            result[targets1.length + targets2.length + i] = JavaSoundUtils.convertFormat(targetsSpecial[i]);
            logger.finer("getSupportedOutputFormats: " + result[targets1.length + targets2.length + i]);
        }
        for (i = 0; i < result.length; ++i) {
            AudioFormat a = (AudioFormat)result[i];
            AudioFormat inputAudioFormat = (AudioFormat)input;
            if (!FormatUtils.specified(inputAudioFormat.getSampleRate()) || FormatUtils.specified(a.getSampleRate())) continue;
            result[i] = null;
        }
        return result;
    }

    @Override
    public void open() throws ResourceUnavailableException {
        super.open();
        this.bufferQueueInputStream = new BufferQueueInputStream();
        javax.sound.sampled.AudioFormat javaSoundAudioFormat = JavaSoundUtils.convertFormat((AudioFormat)this.inputFormat);
        logger.fine("javaSoundAudioFormat converted (in)=" + javaSoundAudioFormat);
        byte[] header = JavaSoundCodec.fakeHeader(javaSoundAudioFormat);
        if (header == null) {
            throw new ResourceUnavailableException("Unable to reconstruct header for format: " + this.inputFormat);
        }
        if (header.length > 0) {
            Buffer headerBuffer = new Buffer();
            headerBuffer.setData(header);
            headerBuffer.setLength(header.length);
            this.bufferQueueInputStream.put(headerBuffer);
        }
        this.audioInputStreamThread = new AudioInputStreamThread(this.bufferQueueInputStream);
        this.audioInputStreamThread.start();
    }

    @Override
    public int process(Buffer input, Buffer output) {
        if (!this.checkInputBuffer(input)) {
            return 1;
        }
        try {
            int lenToRead;
            boolean noRoomInBufferQueue;
            if (this.trace) {
                logger.fine("process: " + LoggingStringUtils.bufferToStr(input));
            }
            this.totalIn += input.getLength();
            boolean bl = noRoomInBufferQueue = !this.bufferQueueInputStream.put(input);
            if (this.audioInputStreamConverted == null) {
                if (noRoomInBufferQueue) {
                    logger.fine("JavaSoundCodec: audioInputStreamConverted == null, blocking until not null");
                    try {
                        while (this.audioInputStreamConverted == null) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        return 1;
                    }
                } else {
                    logger.fine("JavaSoundCodec: audioInputStreamConverted == null, returning OUTPUT_BUFFER_NOT_FILLED");
                    output.setLength(0);
                    return 4;
                }
            }
            int avail = this.audioInputStreamConverted.available();
            if (this.trace) {
                logger.fine("audioInputStreamConverted.available() == " + avail + ", bufferQueueInputStream.available() = " + this.bufferQueueInputStream.available());
            }
            if (output.getData() == null) {
                output.setData(new byte[10000]);
            }
            output.setFormat(this.getOutputFormat());
            byte[] data = (byte[])output.getData();
            if (noRoomInBufferQueue || input.isEOM()) {
                lenToRead = data.length;
            } else {
                int n = lenToRead = avail > data.length ? data.length : avail;
            }
            if (lenToRead == 0) {
                logger.finer("JavaSoundCodec: lenToRead == 0, returning OUTPUT_BUFFER_NOT_FILLED.  input.isEOM()=" + input.isEOM());
                output.setLength(0);
                return 4;
            }
            int lenRead = this.audioInputStreamConverted.read(data, 0, lenToRead);
            logger.finer("JavaSoundCodec: Read from audioInputStreamConverted: " + lenRead);
            if (lenRead == -1) {
                logger.fine("total in: " + this.totalIn + " total out: " + this.totalOut);
                output.setEOM(true);
                output.setLength(0);
                return 0;
            }
            output.setLength(lenRead);
            this.totalOut += lenRead;
            return noRoomInBufferQueue || input.isEOM() ? 2 : 0;
        }
        catch (IOException e) {
            output.setLength(0);
            return 1;
        }
    }

    void setTrace(boolean value) {
        this.trace = value;
    }

    private class AudioInputStreamThread
    extends Thread {
        private final BufferQueueInputStream bufferQueueInputStream;

        public AudioInputStreamThread(BufferQueueInputStream bufferQueueInputStream) {
            this.bufferQueueInputStream = bufferQueueInputStream;
        }

        @Override
        public void run() {
            try {
                JavaSoundCodec.this.audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(this.bufferQueueInputStream));
            }
            catch (UnsupportedAudioFileException e) {
                logger.log(Level.WARNING, "" + e, e);
                return;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                return;
            }
            javax.sound.sampled.AudioFormat javaSoundAudioFormat = JavaSoundUtils.convertFormat((AudioFormat)JavaSoundCodec.this.outputFormat);
            logger.fine("javaSoundAudioFormat converted (out)=" + javaSoundAudioFormat);
            JavaSoundCodec.this.audioInputStreamConverted = AudioSystem.getAudioInputStream(javaSoundAudioFormat, JavaSoundCodec.this.audioInputStream);
        }
    }
}

