/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.RTPPacketSender;
import net.sf.fmj.media.rtp.util.UDPPacket;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;
    private DatagramSocket socket = null;
    private RTPConnector rtpConnector = null;

    public RTPRawSender(int port, String address) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(address);
        this.destport = port;
        this.destAddressList = null;
    }

    public RTPRawSender(int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(port, address);
        this.socket = sender.getSocket();
        this.setConsumer(sender);
        this.destAddressList = null;
    }

    public RTPRawSender(RTPPacketSender sender) {
        this.rtpConnector = sender.getConnector();
        this.setConsumer(sender);
    }

    public void assemble(RTPPacket p) {
        int len = p.calcLength();
        p.assemble(len, false);
    }

    @Override
    public String filtername() {
        return "RTP Raw Packet Sender";
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public int getSendBufSize() {
        try {
            if (this.socket != null) {
                Class<?> cls = this.socket.getClass();
                Method m = cls.getMethod("getSendBufferSize", new Class[0]);
                Integer res = (Integer)m.invoke((Object)this.socket, new Object[0]);
                return res;
            }
            if (this.rtpConnector != null) {
                return this.rtpConnector.getSendBufferSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public Packet handlePacket(Packet p) {
        this.assemble((RTPPacket)p);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = this.destaddr;
        udpp.remotePort = this.destport;
        return udpp;
    }

    @Override
    public Packet handlePacket(Packet p, int i) {
        return null;
    }

    @Override
    public Packet handlePacket(Packet p, SessionAddress sessionAddress) {
        this.assemble((RTPPacket)p);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = sessionAddress.getDataAddress();
        udpp.remotePort = sessionAddress.getDataPort();
        return udpp;
    }

    public void setDestAddresses(Vector destAddresses) {
        this.destAddressList = destAddresses;
    }

    public void setSendBufSize(int size) {
        try {
            if (this.socket != null) {
                Class<?> cls = this.socket.getClass();
                Method m = cls.getMethod("setSendBufferSize", Integer.TYPE);
                m.invoke((Object)this.socket, new Integer(size));
            } else if (this.rtpConnector != null) {
                this.rtpConnector.setSendBufferSize(size);
            }
        }
        catch (Exception e) {
            Log.comment("Cannot set send buffer size: " + e);
        }
    }
}

