/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.Option;

public class OptionGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Option> optionMap = new LinkedHashMap<String, Option>();
    private String selected;
    private boolean required;

    public OptionGroup addOption(Option option) {
        this.optionMap.put(option.getKey(), option);
        return this;
    }

    public Collection<String> getNames() {
        return this.optionMap.keySet();
    }

    public Collection<Option> getOptions() {
        return this.optionMap.values();
    }

    public void setSelected(Option option) throws AlreadySelectedException {
        if (option == null) {
            this.selected = null;
            return;
        }
        if (this.selected != null && !this.selected.equals(option.getKey())) {
            throw new AlreadySelectedException(this, option);
        }
        this.selected = option.getKey();
    }

    public String getSelected() {
        return this.selected;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Option> iterator = this.getOptions().iterator();
        stringBuilder.append("[");
        while (iterator.hasNext()) {
            Option option = iterator.next();
            if (option.getOpt() != null) {
                stringBuilder.append("-");
                stringBuilder.append(option.getOpt());
            } else {
                stringBuilder.append("--");
                stringBuilder.append(option.getLongOpt());
            }
            if (option.getDescription() != null) {
                stringBuilder.append(" ");
                stringBuilder.append(option.getDescription());
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

