/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class BDDMockito
extends Mockito {
    public static <T> BDDMyOngoingStubbing<T> given(T t) {
        return new BDDOngoingStubbingImpl<T>(Mockito.when(t));
    }

    public static <T> Then<T> then(T t) {
        return new ThenImpl<T>(t);
    }

    public static BDDStubber willThrow(Throwable throwable) {
        return new BDDStubberImpl(Mockito.doThrow(throwable));
    }

    public static BDDStubber willThrow(Class<? extends Throwable> clazz) {
        return new BDDStubberImpl(Mockito.doThrow(clazz));
    }

    public static BDDStubber willAnswer(Answer answer) {
        return new BDDStubberImpl(Mockito.doAnswer(answer));
    }

    public static BDDStubber willDoNothing() {
        return new BDDStubberImpl(Mockito.doNothing());
    }

    public static BDDStubber willReturn(Object object) {
        return new BDDStubberImpl(Mockito.doReturn(object));
    }

    public static BDDStubber willCallRealMethod() {
        return new BDDStubberImpl(Mockito.doCallRealMethod());
    }

    @Deprecated
    public static class BDDStubberImpl
    implements BDDStubber {
        private final Stubber mockitoStubber;

        public BDDStubberImpl(Stubber stubber) {
            this.mockitoStubber = stubber;
        }

        @Override
        public <T> T given(T t) {
            return this.mockitoStubber.when(t);
        }

        @Override
        public BDDStubber willAnswer(Answer answer) {
            return new BDDStubberImpl(this.mockitoStubber.doAnswer(answer));
        }

        @Override
        public BDDStubber willNothing() {
            return new BDDStubberImpl(this.mockitoStubber.doNothing());
        }

        @Override
        public BDDStubber willReturn(Object object) {
            return new BDDStubberImpl(this.mockitoStubber.doReturn(object));
        }

        @Override
        public BDDStubber willThrow(Throwable throwable) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(throwable));
        }

        @Override
        public BDDStubber willThrow(Class<? extends Throwable> clazz) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(clazz));
        }

        @Override
        public BDDStubber willCallRealMethod() {
            return new BDDStubberImpl(this.mockitoStubber.doCallRealMethod());
        }
    }

    public static interface BDDStubber {
        public BDDStubber willAnswer(Answer var1);

        public BDDStubber willNothing();

        public BDDStubber willReturn(Object var1);

        public BDDStubber willThrow(Throwable var1);

        public BDDStubber willThrow(Class<? extends Throwable> var1);

        public BDDStubber willCallRealMethod();

        public <T> T given(T var1);
    }

    static class ThenImpl<T>
    implements Then<T> {
        private final T mock;

        ThenImpl(T t) {
            this.mock = t;
        }

        @Override
        public T should() {
            return Mockito.verify(this.mock);
        }

        @Override
        public T should(VerificationMode verificationMode) {
            return Mockito.verify(this.mock, verificationMode);
        }
    }

    public static interface Then<T> {
        public T should();

        public T should(VerificationMode var1);
    }

    @Deprecated
    public static class BDDOngoingStubbingImpl<T>
    implements BDDMyOngoingStubbing<T> {
        private final OngoingStubbing<T> mockitoOngoingStubbing;

        public BDDOngoingStubbingImpl(OngoingStubbing<T> ongoingStubbing) {
            this.mockitoOngoingStubbing = ongoingStubbing;
        }

        @Override
        public BDDMyOngoingStubbing<T> willAnswer(Answer<?> answer) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenAnswer(answer));
        }

        @Override
        public BDDMyOngoingStubbing<T> will(Answer<?> answer) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.then(answer));
        }

        @Override
        public BDDMyOngoingStubbing<T> willReturn(T t) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenReturn(t));
        }

        @Override
        public BDDMyOngoingStubbing<T> willReturn(T t, T ... TArray) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenReturn(t, TArray));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Throwable ... throwableArray) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(throwableArray));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> ... classArray) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(classArray));
        }

        @Override
        public BDDMyOngoingStubbing<T> willCallRealMethod() {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenCallRealMethod());
        }

        @Override
        public <M> M getMock() {
            return this.mockitoOngoingStubbing.getMock();
        }
    }

    public static interface BDDMyOngoingStubbing<T> {
        public BDDMyOngoingStubbing<T> willAnswer(Answer<?> var1);

        public BDDMyOngoingStubbing<T> will(Answer<?> var1);

        public BDDMyOngoingStubbing<T> willReturn(T var1);

        public BDDMyOngoingStubbing<T> willReturn(T var1, T ... var2);

        public BDDMyOngoingStubbing<T> willThrow(Throwable ... var1);

        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> ... var1);

        public BDDMyOngoingStubbing<T> willCallRealMethod();

        public <M> M getMock();
    }
}

