/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.reflect.Field;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.util.reflection.GenericMaster;

public class CaptorAnnotationProcessor
implements FieldAnnotationProcessor<Captor> {
    @Override
    public Object process(Captor captor, Field field) {
        Class<?> clazz = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(clazz)) {
            throw new MockitoException("@Captor field must be of the type ArgumentCaptor.\nField: '" + field.getName() + "' has wrong type\n" + "For info how to use @Captor annotations see examples in javadoc for MockitoAnnotations class.");
        }
        Class clazz2 = new GenericMaster().getGenericType(field);
        return ArgumentCaptor.forClass(clazz2);
    }
}

