/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.mockito.internal.util.collections.Sets;

public class InjectingAnnotationEngine
implements AnnotationEngine {
    private final AnnotationEngine delegate = new DefaultAnnotationEngine();
    private final AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    @Deprecated
    public Object createMockFor(Annotation annotation, Field field) {
        return this.delegate.createMockFor(annotation, field);
    }

    @Override
    public void process(Class<?> clazz, Object object) {
        this.processIndependentAnnotations(object.getClass(), object);
        this.processInjectMocks(object.getClass(), object);
    }

    private void processInjectMocks(Class<?> clazz, Object object) {
        for (Class<?> clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            this.injectMocks(object);
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object object) {
        for (Class<?> clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            this.delegate.process(clazz2, object);
            this.spyAnnotationEngine.process(clazz2, object);
        }
    }

    public void injectMocks(Object object) {
        HashSet<Field> hashSet = new HashSet<Field>();
        Set<Object> set = Sets.newMockSafeHashSet(new Object[0]);
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(hashSet);
            new MockScanner(object, clazz).addPreparedMocks(set);
        }
        new DefaultInjectionEngine().injectMocksOnFields(hashSet, set, object);
    }
}

