/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.misusing.MockitoConfigurationException;
import org.mockito.internal.configuration.plugins.PluginFinder;
import org.mockito.internal.util.collections.Iterables;
import org.mockito.plugins.PluginSwitch;

class PluginLoader {
    private final PluginSwitch pluginSwitch;

    public PluginLoader(PluginSwitch pluginSwitch) {
        this.pluginSwitch = pluginSwitch;
    }

    <T> T loadPlugin(Class<T> clazz, String string) {
        T t = this.loadImpl(clazz);
        if (t != null) {
            return t;
        }
        try {
            return clazz.cast(Class.forName(string).newInstance());
        }
        catch (Exception exception) {
            throw new MockitoException("Internal problem occurred, please report it. Mockito is unable to load the default implementation of class that is a part of Mockito distribution. Failed to load " + clazz, exception);
        }
    }

    <T> T loadImpl(Class<T> clazz) {
        Enumeration<URL> enumeration;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            enumeration = classLoader.getResources("mockito-extensions/" + clazz.getName());
        }
        catch (IOException iOException) {
            throw new MockitoException("Failed to load " + clazz, iOException);
        }
        try {
            String string = new PluginFinder(this.pluginSwitch).findPluginClass(Iterables.toIterable(enumeration));
            if (string != null) {
                Class<?> clazz2 = classLoader.loadClass(string);
                Object obj = clazz2.newInstance();
                return clazz.cast(obj);
            }
            return null;
        }
        catch (Exception exception) {
            throw new MockitoConfigurationException("Failed to load " + clazz + " implementation declared in " + enumeration, exception);
        }
    }
}

