/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.lang.reflect.Method;
import org.mockito.internal.invocation.MockitoMethod;

public class DelegatingMethod
implements MockitoMethod {
    private final Method method;

    public DelegatingMethod(Method method) {
        assert (method != null) : "Method cannot be null";
        this.method = method;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Method getJavaMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    public boolean isAbstract() {
        return (this.method.getModifiers() & 0x400) != 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DelegatingMethod) {
            DelegatingMethod delegatingMethod = (DelegatingMethod)object;
            return this.method.equals(delegatingMethod.method);
        }
        return this.method.equals(object);
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

