/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.cglib.MockitoNamingPolicy;
import org.mockito.internal.creation.cglib.SerializableNoOp;
import org.mockito.internal.creation.instance.InstantationException;
import org.mockito.internal.creation.instance.Instantiator;
import org.mockito.internal.creation.util.SearchingClassLoader;
import org.mockito.internal.util.StringJoiner;

class ClassImposterizer {
    private final Instantiator instantiator;
    private static final NamingPolicy NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES = new MockitoNamingPolicy(){

        public String getClassName(String string, String string2, Object object, Predicate predicate) {
            return "codegen." + super.getClassName(string, string2, object, predicate);
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    public ClassImposterizer(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public <T> T imposterise(MethodInterceptor methodInterceptor, Class<T> clazz, Collection<Class> collection) {
        return this.imposterise(methodInterceptor, clazz, collection.toArray(new Class[collection.size()]));
    }

    public <T> T imposterise(MethodInterceptor methodInterceptor, Class<T> clazz, Class<?> ... classArray) {
        Class<Factory> clazz2 = null;
        Object object = null;
        try {
            this.setConstructorsAccessible(clazz, true);
            clazz2 = this.createProxyClass(clazz, classArray);
            object = this.createProxy(clazz2, methodInterceptor);
            T t = clazz.cast(object);
            return t;
        }
        catch (ClassCastException classCastException) {
            throw new MockitoException(StringJoiner.join("ClassCastException occurred while creating the mockito proxy :", "  class to mock : " + ClassImposterizer.describeClass(clazz), "  created class : " + ClassImposterizer.describeClass(clazz2), "  proxy instance class : " + ClassImposterizer.describeClass(object), "  instance creation by : " + this.instantiator.getClass().getSimpleName(), "", "You might experience classloading issues, disabling the Objenesis cache *might* help (see MockitoConfiguration)"), classCastException);
        }
        finally {
            this.setConstructorsAccessible(clazz, false);
        }
    }

    private static String describeClass(Class clazz) {
        return clazz == null ? "null" : "'" + clazz.getCanonicalName() + "', loaded by classloader : '" + clazz.getClassLoader() + "'";
    }

    private static String describeClass(Object object) {
        return object == null ? "null" : ClassImposterizer.describeClass(object.getClass());
    }

    public void setConstructorsAccessible(Class<?> clazz, boolean bl) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            constructor.setAccessible(bl);
        }
    }

    public Class<Factory> createProxyClass(Class<?> clazz, Class<?> ... classArray) {
        if (clazz == Object.class) {
            clazz = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class clazz, List list) {
            }
        };
        Class[] classArray2 = this.prepend(clazz, classArray);
        enhancer.setClassLoader(SearchingClassLoader.combineLoadersOf(classArray2));
        enhancer.setUseFactory(true);
        if (clazz.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces(classArray2);
        } else {
            enhancer.setSuperclass(clazz);
            enhancer.setInterfaces((Class[])classArray);
        }
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        if (clazz.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES);
        } else {
            enhancer.setNamingPolicy((NamingPolicy)MockitoNamingPolicy.INSTANCE);
        }
        enhancer.setSerialVersionUID(Long.valueOf(42L));
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException codeGenerationException) {
            if (Modifier.isPrivate(clazz.getModifiers())) {
                throw new MockitoException("\nMockito cannot mock this class: " + clazz + ".\n" + "Most likely it is a private class that is not visible by Mockito");
            }
            throw new MockitoException("\nMockito cannot mock this class: " + clazz + "\n" + "Mockito can only mock visible & non-final classes." + "\n" + "If you're not sure why you're getting this error, please report to the mailing list.", codeGenerationException);
        }
    }

    private Object createProxy(Class<Factory> clazz, MethodInterceptor methodInterceptor) {
        Factory factory;
        try {
            factory = this.instantiator.newInstance(clazz);
        }
        catch (InstantationException instantationException) {
            throw new MockitoException("Unable to create mock instance of type '" + clazz.getSuperclass().getSimpleName() + "'", instantationException);
        }
        factory.setCallbacks(new Callback[]{methodInterceptor, SerializableNoOp.SERIALIZABLE_INSTANCE});
        return factory;
    }

    private Class<?>[] prepend(Class<?> clazz, Class<?> ... classArray) {
        Class[] classArray2 = new Class[classArray.length + 1];
        classArray2[0] = clazz;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return classArray2;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }
}

