/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.mockito.internal.matchers.ContainsExtraTypeInformation;
import org.mockito.internal.reporting.PrintSettings;

public class MatchersPrinter {
    public String getArgumentsLine(List<Matcher> list, PrintSettings printSettings) {
        StringDescription stringDescription = new StringDescription();
        stringDescription.appendList("(", ", ", ");", this.applyPrintSettings(list, printSettings));
        return stringDescription.toString();
    }

    public String getArgumentsBlock(List<Matcher> list, PrintSettings printSettings) {
        StringDescription stringDescription = new StringDescription();
        stringDescription.appendList("(\n    ", ",\n    ", "\n);", this.applyPrintSettings(list, printSettings));
        return stringDescription.toString();
    }

    private List<SelfDescribing> applyPrintSettings(List<Matcher> list, PrintSettings printSettings) {
        LinkedList<SelfDescribing> linkedList = new LinkedList<SelfDescribing>();
        int n = 0;
        for (Matcher matcher : list) {
            if (matcher instanceof ContainsExtraTypeInformation && printSettings.extraTypeInfoFor(n)) {
                linkedList.add(((ContainsExtraTypeInformation)matcher).withExtraTypeInfo());
            } else {
                linkedList.add((SelfDescribing)matcher);
            }
            ++n;
        }
        return linkedList;
    }
}

