/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.reporting;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.invocation.ArgumentsProcessor;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.matchers.MatchersPrinter;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.Invocation;

public class PrintSettings {
    public static final int MAX_LINE_LENGTH = 45;
    private boolean multiline;
    private List<Integer> withTypeInfo = new LinkedList<Integer>();

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public static PrintSettings verboseMatchers(Integer ... integerArray) {
        PrintSettings printSettings = new PrintSettings();
        printSettings.setMatchersToBeDescribedWithExtraTypeInfo(integerArray);
        return printSettings;
    }

    public boolean extraTypeInfoFor(int n) {
        return this.withTypeInfo.contains(n);
    }

    public void setMatchersToBeDescribedWithExtraTypeInfo(Integer[] integerArray) {
        this.withTypeInfo = Arrays.asList(integerArray);
    }

    public String print(List<Matcher> list, Invocation invocation) {
        MatchersPrinter matchersPrinter = new MatchersPrinter();
        String string = new MockUtil().getMockName(invocation.getMock()) + "." + invocation.getMethod().getName();
        String string2 = string + matchersPrinter.getArgumentsLine(list, this);
        if (this.isMultiline() || !list.isEmpty() && string2.length() > 45) {
            return string + matchersPrinter.getArgumentsBlock(list, this);
        }
        return string2;
    }

    public String print(Invocation invocation) {
        return this.print(ArgumentsProcessor.argumentsToMatchers(invocation.getArguments()), invocation);
    }

    public String print(InvocationMatcher invocationMatcher) {
        return this.print(invocationMatcher.getMatchers(), invocationMatcher.getInvocation());
    }
}

