/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.util.LinkedList;
import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

public class StubberImpl
implements Stubber {
    final List<Answer> answers = new LinkedList<Answer>();
    private final Reporter reporter = new Reporter();

    @Override
    public <T> T when(T t) {
        MockUtil mockUtil = new MockUtil();
        if (t == null) {
            this.reporter.nullPassedToWhenMethod();
        } else if (!mockUtil.isMock(t)) {
            this.reporter.notAMockPassedToWhenMethod();
        }
        mockUtil.getMockHandler(t).setAnswersForStubbing(this.answers);
        return t;
    }

    @Override
    public Stubber doReturn(Object object) {
        this.answers.add(new Returns(object));
        return this;
    }

    @Override
    public Stubber doThrow(Throwable throwable) {
        this.answers.add(new ThrowsException(throwable));
        return this;
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> clazz) {
        this.answers.add(new ThrowsExceptionClass(clazz));
        return this;
    }

    @Override
    public Stubber doNothing() {
        this.answers.add(new DoesNothing());
        return this;
    }

    @Override
    public Stubber doAnswer(Answer answer) {
        this.answers.add(answer);
        return this;
    }

    @Override
    public Stubber doCallRealMethod() {
        this.answers.add(new CallsRealMethods());
        return this;
    }
}

