/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.mock.MockName;
import org.mockito.stubbing.Answer;

public class ReturnsEmptyValues
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 1998191268711234347L;
    ObjectMethodsGuru methodsGuru = new ObjectMethodsGuru();
    MockUtil mockUtil = new MockUtil();

    @Override
    public Object answer(InvocationOnMock invocationOnMock) {
        if (this.methodsGuru.isToString(invocationOnMock.getMethod())) {
            Object object = invocationOnMock.getMock();
            MockName mockName = this.mockUtil.getMockName(object);
            if (mockName.isDefault()) {
                return "Mock for " + this.mockUtil.getMockSettings(object).getTypeToMock().getSimpleName() + ", hashCode: " + object.hashCode();
            }
            return mockName.toString();
        }
        if (this.methodsGuru.isCompareToMethod(invocationOnMock.getMethod())) {
            return invocationOnMock.getMock() == invocationOnMock.getArguments()[0] ? 0 : 1;
        }
        Class<?> clazz = invocationOnMock.getMethod().getReturnType();
        return this.returnValueFor(clazz);
    }

    Object returnValueFor(Class<?> clazz) {
        if (Primitives.isPrimitiveOrWrapper(clazz)) {
            return Primitives.defaultValueForPrimitiveOrWrapper(clazz);
        }
        if (clazz == Collection.class) {
            return new LinkedList();
        }
        if (clazz == Set.class) {
            return new HashSet();
        }
        if (clazz == HashSet.class) {
            return new HashSet();
        }
        if (clazz == SortedSet.class) {
            return new TreeSet();
        }
        if (clazz == TreeSet.class) {
            return new TreeSet();
        }
        if (clazz == LinkedHashSet.class) {
            return new LinkedHashSet();
        }
        if (clazz == List.class) {
            return new LinkedList();
        }
        if (clazz == LinkedList.class) {
            return new LinkedList();
        }
        if (clazz == ArrayList.class) {
            return new ArrayList();
        }
        if (clazz == Map.class) {
            return new HashMap();
        }
        if (clazz == HashMap.class) {
            return new HashMap();
        }
        if (clazz == SortedMap.class) {
            return new TreeMap();
        }
        if (clazz == TreeMap.class) {
            return new TreeMap();
        }
        if (clazz == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        return null;
    }
}

