/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.collections;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.internal.util.collections.HashCodeAndEqualsSafeSet;
import org.mockito.internal.util.collections.IdentitySet;

public abstract class Sets {
    public static Set<Object> newMockSafeHashSet(Iterable<Object> iterable) {
        return HashCodeAndEqualsSafeSet.of(iterable);
    }

    public static Set<Object> newMockSafeHashSet(Object ... objectArray) {
        return HashCodeAndEqualsSafeSet.of(objectArray);
    }

    public static IdentitySet newIdentitySet() {
        return new IdentitySet();
    }

    public static <T> Set<T> newSet(T ... TArray) {
        if (TArray == null) {
            throw new IllegalArgumentException("Expected an array of elements (or empty array) but received a null.");
        }
        return new LinkedHashSet<T>(Arrays.asList(TArray));
    }
}

