/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationDataInOrder;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.internal.verification.checkers.MissingInvocationInOrderChecker;
import org.mockito.internal.verification.checkers.NonGreedyNumberOfInvocationsInOrderChecker;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class Calls
implements VerificationMode,
VerificationInOrderMode {
    final int wantedCount;

    public Calls(int n) {
        if (n <= 0) {
            throw new MockitoException("Negative and zero values are not allowed here");
        }
        this.wantedCount = n;
    }

    @Override
    public void verify(VerificationData verificationData) {
        throw new MockitoException("calls is only intended to work with InOrder");
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder verificationDataInOrder) {
        List<Invocation> list = verificationDataInOrder.getAllInvocations();
        InvocationMatcher invocationMatcher = verificationDataInOrder.getWanted();
        MissingInvocationInOrderChecker missingInvocationInOrderChecker = new MissingInvocationInOrderChecker();
        missingInvocationInOrderChecker.check(list, invocationMatcher, this, verificationDataInOrder.getOrderingContext());
        NonGreedyNumberOfInvocationsInOrderChecker nonGreedyNumberOfInvocationsInOrderChecker = new NonGreedyNumberOfInvocationsInOrderChecker();
        nonGreedyNumberOfInvocationsInOrderChecker.check(list, invocationMatcher, this.wantedCount, verificationDataInOrder.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count (non-greedy): " + this.wantedCount;
    }
}

