/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ModuleUpdaterDialog;
import VASSAL.configure.SaveAction;
import VASSAL.configure.SaveAsAction;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidationReportDialog;
import VASSAL.i18n.Resources;
import VASSAL.launch.AboutVASSALAction;
import VASSAL.launch.ShutDownAction;
import VASSAL.tools.ApplicationIcons;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.lang.SystemUtils;

public abstract class EditorWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected SaveAction saveAction;
    protected SaveAsAction saveAsAction;
    protected JMenuItem componentHelpItem;
    protected Action createUpdater;
    protected final HelpWindow helpWindow = new HelpWindow(Resources.getString("Editor.ModuleEditor.reference_manual"), null);
    protected ConfigureTree tree;
    protected final JToolBar toolBar = new JToolBar();
    protected final JScrollPane scrollPane;

    public abstract String getEditorType();

    protected EditorWindow() {
        Serializable serializable;
        MenuProxy menuProxy;
        this.setTitle("VASSAL " + this.getEditorType() + " Editor");
        this.setLayout(new BorderLayout());
        ApplicationIcons.setFor(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditorWindow.this.close();
            }
        });
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        MenuManager menuManager = MenuManager.getInstance();
        MenuBarProxy menuBarProxy = menuManager.getMenuBarProxyFor(this);
        if (SystemUtils.IS_OS_MAC_OSX) {
            menuManager.addToSection("Editor.File", menuManager.addKey("Editor.save"));
            menuManager.addToSection("Editor.File", menuManager.addKey("Editor.save_as"));
        } else {
            menuProxy = new MenuProxy(Resources.getString("General.file"));
            menuProxy.setMnemonic(Resources.getString("General.file.shortcut").charAt(0));
            menuProxy.add(menuManager.addKey("Editor.save"));
            menuProxy.add(menuManager.addKey("Editor.save_as"));
            menuProxy.addSeparator();
            menuProxy.add(menuManager.addKey("General.quit"));
            menuBarProxy.add(menuProxy);
        }
        menuProxy = new MenuProxy(Resources.getString("General.edit"));
        menuProxy.setMnemonic(Resources.getString("General.edit.shortcut").charAt(0));
        menuProxy.add(menuManager.addKey("Editor.cut"));
        menuProxy.add(menuManager.addKey("Editor.copy"));
        menuProxy.add(menuManager.addKey("Editor.paste"));
        menuProxy.add(menuManager.addKey("Editor.move"));
        menuProxy.addSeparator();
        menuProxy.add(menuManager.addKey("Editor.ModuleEditor.properties"));
        menuProxy.add(menuManager.addKey("Editor.ModuleEditor.translate"));
        MenuProxy menuProxy2 = new MenuProxy(Resources.getString("General.tools"));
        menuProxy2.setMnemonic(Resources.getString("General.tools.shortcut").charAt(0));
        menuProxy2.add(menuManager.addKey("create_module_updater"));
        menuProxy2.add(menuManager.addKey("Editor.ModuleEditor.update_saved"));
        if (SystemUtils.IS_OS_MAC_OSX) {
            menuManager.addToSection("Editor.MenuBar", menuProxy);
            menuManager.addToSection("Editor.MenuBar", menuProxy2);
        } else {
            menuBarProxy.add(menuProxy);
            menuBarProxy.add(menuProxy2);
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            menuManager.addToSection("Documentation.VASSAL", menuManager.addKey("Editor.ModuleEditor.reference_manual"));
        } else {
            MenuProxy menuProxy3 = new MenuProxy(Resources.getString("General.help"));
            menuProxy3.setMnemonic(Resources.getString("General.help.shortcut").charAt(0));
            menuProxy3.add(menuManager.addKey("General.help"));
            menuProxy3.add(menuManager.addKey("Help.user_guide"));
            menuProxy3.add(menuManager.addKey("Editor.ModuleEditor.reference_manual"));
            menuProxy3.addSeparator();
            menuProxy3.add(menuManager.addKey("AboutScreen.about_vassal"));
            menuBarProxy.add(menuProxy3);
        }
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.saveAction = new SaveAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                EditorWindow.this.save();
                EditorWindow.this.treeStateChanged(false);
            }
        };
        this.saveAction.setEnabled(false);
        this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, n));
        menuManager.addAction("Editor.save", this.saveAction);
        this.toolBar.add(this.saveAction);
        this.saveAsAction = new SaveAsAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                EditorWindow.this.saveAs();
                EditorWindow.this.treeStateChanged(false);
            }
        };
        this.saveAsAction.setEnabled(false);
        this.saveAsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, n));
        menuManager.addAction("Editor.save_as", this.saveAsAction);
        this.toolBar.add(this.saveAsAction);
        menuManager.addAction("General.quit", new ShutDownAction());
        this.createUpdater = new AbstractAction("Create " + this.getEditorType() + " updater"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                new ModuleUpdaterDialog(EditorWindow.this).setVisible(true);
            }
        };
        this.createUpdater.setEnabled(false);
        menuManager.addAction("create_module_updater", this.createUpdater);
        try {
            serializable = new File(Documentation.getDocumentationBaseDir(), "README.html").toURI().toURL();
            menuManager.addAction("General.help", new ShowHelpAction((URL)serializable, null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        try {
            serializable = new File(Documentation.getDocumentationBaseDir(), "userguide/userguide.pdf").toURI().toURL();
            menuManager.addAction("Help.user_guide", new ShowHelpAction("Help.user_guide", (URL)serializable, null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        try {
            serializable = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/index.htm").toURI().toURL();
            ShowHelpAction showHelpAction = new ShowHelpAction((URL)serializable, this.helpWindow.getClass().getResource("/images/Help16.gif"));
            showHelpAction.putValue("ShortDescription", Resources.getString("Editor.ModuleEditor.reference_manual"));
            this.toolBar.add(showHelpAction);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        menuManager.addAction("AboutScreen.about_vassal", new AboutVASSALAction(this));
        this.setJMenuBar(menuManager.getMenuBarFor(this));
        serializable = new JPanel();
        ((JComponent)serializable).setPreferredSize(new Dimension(250, 400));
        this.scrollPane = new JScrollPane((Component)serializable, 20, 30);
        this.add((Component)this.scrollPane, "Center");
        this.pack();
    }

    protected MenuProxy findMenuProxy(String string, MenuBarProxy menuBarProxy) {
        for (ChildProxy<?> childProxy : menuBarProxy.getChildren()) {
            MenuProxy menuProxy;
            if (!(childProxy instanceof MenuProxy) || !string.equals((menuProxy = (MenuProxy)childProxy).getText())) continue;
            return menuProxy;
        }
        return null;
    }

    protected abstract void save();

    protected abstract void saveAs();

    protected void close() {
        GameModule.getGameModule().quit();
    }

    protected void saver(final Runnable runnable) {
        ValidationReport validationReport = new ValidationReport();
        GameModule.getGameModule().validate(GameModule.getGameModule(), validationReport);
        if (validationReport.getWarnings().size() == 0) {
            runnable.run();
        } else {
            new ValidationReportDialog(validationReport, new ValidationReportDialog.CallBack(){

                public void ok() {
                    runnable.run();
                }

                public void cancel() {
                }
            }).setVisible(true);
        }
    }

    public void treeStateChanged(boolean bl) {
    }
}

