/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.property;

import VASSAL.property.Property;
import VASSAL.property.PropertyListener;
import VASSAL.property.PropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentPropertySupport
implements PropertySupport {
    protected final CopyOnWriteArrayList<PropertyListener<Object>> listeners = new CopyOnWriteArrayList();
    protected final ConcurrentMap<Property<?>, List<PropertyListener<?>>> plisteners = new ConcurrentHashMap();

    @Override
    public void addPropertyListener(PropertyListener<Object> propertyListener) {
        if (propertyListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(propertyListener);
    }

    @Override
    public void removePropertyListener(PropertyListener<Object> propertyListener) {
        if (propertyListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(propertyListener);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public List<PropertyListener<Object>> getPropertyListeners() {
        return this.listeners.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyListener<Object>>(this.listeners);
    }

    @Override
    public <T> void addPropertyListener(Property<T> property, PropertyListener<? super T> propertyListener) {
        CopyOnWriteArrayList<PropertyListener<T>> copyOnWriteArrayList = new CopyOnWriteArrayList<PropertyListener<T>>();
        CopyOnWriteArrayList<PropertyListener<T>> copyOnWriteArrayList2 = this.plisteners.putIfAbsent(property, copyOnWriteArrayList);
        if (copyOnWriteArrayList2 == null) {
            copyOnWriteArrayList2 = copyOnWriteArrayList;
        }
        copyOnWriteArrayList2.add(propertyListener);
    }

    @Override
    public <T> void removePropertyListener(Property<T> property, PropertyListener<? super T> propertyListener) {
        List list = (List)this.plisteners.get(property);
        if (list != null) {
            list.remove(propertyListener);
        }
    }

    @Override
    public <T> List<PropertyListener<? super T>> getPropertyListeners(Property<T> property) {
        List list = (List)this.plisteners.get(property);
        return list == null || list.isEmpty() ? Collections.emptyList() : new ArrayList(list);
    }

    @Override
    public <T> boolean hasListeners(Property<T> property) {
        List list = (List)this.plisteners.get(property);
        return list != null && !list.isEmpty();
    }

    @Override
    public <T> void fireChanged(Object object, Property<T> property, T t, T t2) {
        if (t == t2 || t != null && t.equals(t2)) {
            return;
        }
        for (PropertyListener<Object> object2 : this.listeners) {
            object2.propertyChanged(object, property, t, t2);
        }
        List list = (List)this.plisteners.get(property);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PropertyListener propertyListener = (PropertyListener)iterator.next();
                propertyListener.propertyChanged(object, property, t, t2);
            }
        }
    }
}

