/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.applet.AudioClip;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;

public class Mp3AudioClip
implements AudioClip {
    protected String name;
    protected Player player = null;
    protected InputStream stream = null;

    public Mp3AudioClip(String string) {
        this.name = string;
    }

    public void play() {
        this.stream = null;
        try {
            this.stream = GameModule.getGameModule().getDataArchive().getInputStream(this.name);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.not_found", this.name), "", fileNotFoundException));
            return;
        }
        catch (IOException iOException) {
            ErrorDialog.bug(iOException);
            return;
        }
        this.player = null;
        try {
            this.player = new Player(this.stream);
        }
        catch (JavaLayerException javaLayerException) {
            ErrorDialog.bug(javaLayerException);
            return;
        }
        finally {
            if (this.player == null) {
                IOUtils.closeQuietly((InputStream)this.stream);
            }
        }
        new Thread(){

            public void run() {
                try {
                    Mp3AudioClip.this.player.play();
                }
                catch (JavaLayerException javaLayerException) {
                    ErrorDialog.bug(javaLayerException);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)Mp3AudioClip.this.stream);
                }
            }
        }.start();
    }

    public void stop() {
        if (this.player != null) {
            try {
                this.player.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.stream);
            }
        }
    }

    public void loop() {
    }
}

