/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.IterableEnumeration;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ZipUpdater.class);
    public static final String CHECKSUM_RESOURCE = "checksums";
    public static final String TARGET_ARCHIVE = "target";
    public static final String UPDATED_ARCHIVE_NAME = "finalName";
    public static final String ENTRIES_DIR = "entries/";
    private File oldFile;
    private ZipFile oldZipFile;
    private Properties checkSums;
    private String fileName;
    private Exception error;

    public ZipUpdater(File file) throws IOException {
        this.oldFile = file;
        if (!this.oldFile.exists()) {
            throw new IOException("Could not find file " + file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCrc(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        long l = -1L;
        if (zipEntry != null && (l = zipEntry.getCrc()) < 0L) {
            CRC32 cRC32 = new CRC32();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) >= 0) {
                    cRC32.update(byArray, 0, n);
                }
                inputStream.close();
                l = cRC32.getValue();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return l;
    }

    private long copyEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        return this.writeEntry(this.oldZipFile.getInputStream(new ZipEntry(zipEntry.getName())), zipOutputStream, zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replaceEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        long l;
        InputStream inputStream = this.getClass().getResourceAsStream("/entries/" + zipEntry.getName());
        if (inputStream == null) {
            throw new IOException("This updater was created with an original that differs from the file you're trying to update.\nLocal entry does not match original:  " + zipEntry.getName());
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            long l2 = this.writeEntry(inputStream, zipOutputStream, zipEntry);
            bufferedInputStream.close();
            l = l2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        return l;
    }

    private long writeEntry(InputStream inputStream, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        if (zipEntry.getMethod() == 0) {
            zipEntry.setSize(byArray.length);
            zipEntry.setCrc(cRC32.getValue());
        }
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, byArray.length);
        return cRC32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        String string;
        Object object;
        this.checkSums = new Properties();
        InputStream inputStream = ZipUpdater.class.getResourceAsStream("/checksums");
        if (inputStream == null) {
            throw new IOException("Resource not found: checksums");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            this.checkSums.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        File file2 = File.createTempFile("VSL", ".zip");
        this.oldZipFile = new ZipFile(this.oldFile.getPath());
        try {
            object = new ZipOutputStream(new FileOutputStream(file2));
            try {
                Enumeration<Object> enumeration = this.checkSums.keys();
                while (enumeration.hasMoreElements()) {
                    long l;
                    string = (String)enumeration.nextElement();
                    try {
                        l = Long.parseLong(this.checkSums.getProperty(string, "<none>"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Invalid checksum " + this.checkSums.getProperty(string, "<none>") + " for entry " + string);
                    }
                    ZipEntry zipEntry = this.oldZipFile.getEntry(string);
                    ZipEntry zipEntry2 = new ZipEntry(string);
                    zipEntry2.setMethod(zipEntry != null ? zipEntry.getMethod() : 8);
                    if (!(l == this.getCrc(this.oldZipFile, zipEntry) ? l != this.copyEntry((ZipOutputStream)object, zipEntry2) : l != this.replaceEntry((ZipOutputStream)object, zipEntry2))) continue;
                    throw new IOException("Checksum mismatch for entry " + zipEntry.getName());
                }
            }
            finally {
                try {
                    ((ZipOutputStream)object).close();
                }
                catch (IOException iOException) {
                    logger.error("", (Throwable)iOException);
                }
            }
        }
        finally {
            this.oldZipFile.close();
        }
        if (file.getName().equals(this.oldFile.getName())) {
            object = file.getName();
            int n = ((String)object).lastIndexOf(46);
            String string2 = string = n < 0 || n == ((String)object).length() - 1 ? (String)object + "Backup" : ((String)object).substring(0, n) + "Backup" + ((String)object).substring(n);
            if (!this.oldFile.renameTo(new File(string))) {
                throw new IOException("Unable to create backup file " + string + ".\nUpdated file is in " + file2.getPath());
            }
        }
        if (!file2.renameTo(file)) {
            throw new IOException("Unable to write to file " + file.getPath() + ".\nUpdated file is in " + file2.getPath());
        }
    }

    public void createUpdater(File file) throws IOException {
        String string = this.oldFile.getName();
        int n = string.indexOf(46);
        String string2 = n >= 0 ? "update" + string.substring(0, n) + ".jar" : "update" + string;
        this.createUpdater(file, new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUpdater(File file, File file2) throws IOException {
        String string;
        if (!file2.getName().endsWith(".jar")) {
            string = file2.getName().replace('.', '_') + ".jar";
            file2 = new File(file2.getParentFile(), string);
        }
        this.checkSums = new Properties();
        try {
            this.oldZipFile = new ZipFile(this.oldFile);
            string = this.oldFile.getName();
            ZipFile zipFile = new ZipFile(file);
            try {
                JarOutputStream jarOutputStream = null;
                try {
                    Object object;
                    Object object2;
                    jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                    for (ZipEntry object32 : IterableEnumeration.iterate(zipFile.entries())) {
                        long byteArrayOutputStream;
                        long zipEntry2 = this.getCrc(zipFile, object32);
                        if (zipEntry2 != (byteArrayOutputStream = this.getCrc(this.oldZipFile, this.oldZipFile.getEntry(object32.getName())))) {
                            object2 = new ZipEntry(ENTRIES_DIR + object32.getName());
                            ((ZipEntry)object2).setMethod(object32.getMethod());
                            object = null;
                            try {
                                object = new BufferedInputStream(zipFile.getInputStream(object32));
                                this.writeEntry((InputStream)object, jarOutputStream, (ZipEntry)object2);
                                ((InputStream)object).close();
                            }
                            catch (Throwable inputStream) {
                                IOUtils.closeQuietly(object);
                                throw inputStream;
                            }
                            IOUtils.closeQuietly((InputStream)object);
                        }
                        this.checkSums.put(object32.getName(), zipEntry2 + "");
                    }
                    ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
                    zipEntry.setMethod(8);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Manifest-Version: 1.0\n").append("Main-Class: VASSAL.tools.ZipUpdater\n");
                    this.writeEntry(new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8")), jarOutputStream, zipEntry);
                    ZipEntry zipEntry2 = new ZipEntry(TARGET_ARCHIVE);
                    zipEntry2.setMethod(8);
                    this.writeEntry(new ByteArrayInputStream(string.getBytes("UTF-8")), jarOutputStream, zipEntry2);
                    ZipEntry zipEntry3 = new ZipEntry(UPDATED_ARCHIVE_NAME);
                    zipEntry3.setMethod(8);
                    this.writeEntry(new ByteArrayInputStream(file.getName().getBytes("UTF-8")), jarOutputStream, zipEntry3);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.checkSums.store(byteArrayOutputStream, null);
                    ZipEntry zipEntry4 = new ZipEntry(CHECKSUM_RESOURCE);
                    zipEntry4.setMethod(8);
                    this.writeEntry(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), jarOutputStream, zipEntry4);
                    object2 = this.getClass().getName().replace('.', '/') + ".class";
                    object = new ZipEntry((String)object2);
                    ((ZipEntry)object).setMethod(8);
                    InputStream inputStream = this.getClass().getResourceAsStream("/" + (String)object2);
                    if (inputStream == null) {
                        throw new IOException("Resource not found: " + (String)object2);
                    }
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        bufferedInputStream = new BufferedInputStream(inputStream);
                        this.writeEntry(inputStream, jarOutputStream, (ZipEntry)object);
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bufferedInputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)bufferedInputStream);
                    jarOutputStream.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(jarOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)jarOutputStream);
                zipFile.close();
            }
            finally {
                IOUtils.closeQuietly(zipFile);
            }
            this.oldZipFile.close();
        }
        finally {
            IOUtils.closeQuietly(this.oldZipFile);
        }
    }

    private ZipUpdater(String string, Exception exception) {
        this.fileName = string;
        this.error = exception;
    }

    public void run() {
        JOptionPane.showMessageDialog(null, "Unable to update " + this.fileName + ".\n" + this.error.getMessage(), "Update failed", 0);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        block21: {
            String string = "<unknown>";
            try {
                if (stringArray.length > 1) {
                    string = stringArray[0];
                    String string2 = stringArray[1];
                    ZipUpdater zipUpdater = new ZipUpdater(new File(string));
                    zipUpdater.createUpdater(new File(string2));
                    break block21;
                }
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(ZipUpdater.class.getResourceAsStream("/target")));
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(ZipUpdater.class.getResourceAsStream("/finalName")));
                    String string3 = bufferedReader.readLine();
                    ZipUpdater zipUpdater = new ZipUpdater(new File(string));
                    zipUpdater.write(new File(string3));
                    bufferedReader.close();
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    SwingUtilities.invokeAndWait(new ZipUpdater(string, iOException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

