/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.icon;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.swing.Dialogs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconFamily
extends AbstractConfigurable {
    public static final String SCALABLE_ICON = "scalableIcon";
    public static final String ICON0 = "icon0";
    public static final String ICON1 = "icon1";
    public static final String ICON2 = "icon2";
    public static final String ICON3 = "icon3";
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    public static final int XSMALL = 0;
    public static final int SMALL = 1;
    public static final int MEDIUM = 2;
    public static final int LARGE = 3;
    static final int MAX_SIZE = 3;
    static final int SIZE_COUNT = 4;
    static final int[] SIZES = new int[]{16, 22, 32, 48};
    static final String[] SIZE_DIRS = new String[]{"16x16/", "22x22/", "32x32/", "48x48/"};
    static final String[] SIZE_NAMES = new String[4];
    static final String SCALABLE_DIR = "scalable/";
    protected OpIcon[] icons;
    protected OpIcon scalableIcon;
    protected String scalablePath;
    protected String[] sizePaths = new String[4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getIconSizeNames() {
        String[] stringArray = SIZE_NAMES;
        synchronized (SIZE_NAMES) {
            if (SIZE_NAMES[0] == null) {
                IconFamily.SIZE_NAMES[0] = Resources.getString("Icon.extra_small");
                IconFamily.SIZE_NAMES[1] = Resources.getString("Icon.small");
                IconFamily.SIZE_NAMES[2] = Resources.getString("Icon.medium");
                IconFamily.SIZE_NAMES[3] = Resources.getString("Icon.large");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SIZE_NAMES;
        }
    }

    public static int getIconSize(String string) {
        int n = 1;
        String[] stringArray = IconFamily.getIconSizeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return n;
    }

    public static int getIconHeight(int n) {
        if (n < 0 || n > 3) {
            return 0;
        }
        return SIZES[n];
    }

    public IconFamily(String string, String string2, String[] stringArray) {
        this(string);
        this.setScalableIconPath(string2);
        for (int i = 0; i < 3; ++i) {
            this.setSizeIconPath(i, stringArray[i]);
        }
    }

    public IconFamily(String string) {
        this();
        this.setConfigureName(string);
    }

    public IconFamily() {
        this.icons = new OpIcon[4];
        this.setConfigureName("");
    }

    public void setScalableIconPath(String string) {
        this.scalablePath = string;
        this.scalableIcon = null;
    }

    public void setSizeIconPath(int n, String string) {
        this.sizePaths[n] = string;
        this.icons[n] = null;
    }

    public boolean isLegacy() {
        return this.getName().contains(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        IconFamily iconFamily = this;
        synchronized (iconFamily) {
            if (this.icons[n] == null) {
                this.icons[n] = this.buildIcon(n);
            }
        }
        return this.icons[n];
    }

    public Icon getRawIcon(int n) {
        if (n < 0 || n > 3 || this.sizePaths[n] == null) {
            return null;
        }
        return this.getIcon(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getScalableIcon() {
        IconFamily iconFamily = this;
        synchronized (iconFamily) {
            this.buildScalableIcon();
        }
        return this.scalableIcon;
    }

    public BufferedImage getImage(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        this.getIcon(n);
        return (BufferedImage)(this.icons[n] == null ? null : this.icons[n].getImage());
    }

    protected OpIcon buildIcon(int n) {
        if (this.icons[n] != null) {
            return this.icons[n];
        }
        if (this.sizePaths[n] != null) {
            this.icons[n] = new OpIcon(Op.load(this.sizePaths[n]));
            this.icons[n].getImage();
            return this.icons[n];
        }
        this.buildScalableIcon();
        this.icons[n] = this.scaleIcon(this.scalableIcon, SIZES[n]);
        this.icons[n].getImage();
        return this.icons[n];
    }

    protected void buildScalableIcon() {
        if (this.scalableIcon == null && this.scalablePath != null) {
            this.scalableIcon = new OpIcon(Op.load(this.scalablePath));
        }
    }

    protected OpIcon scaleIcon(OpIcon opIcon, int n) {
        if (opIcon == null) {
            return null;
        }
        int n2 = opIcon.getIconHeight();
        if (n2 == n) {
            return opIcon;
        }
        return new OpIcon(Op.scale(opIcon.getOp(), (double)n / (double)opIcon.getIconHeight()));
    }

    public String getName() {
        return this.getConfigureName();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void setConfigureName(String string) {
        String string2 = this.name;
        this.name = string;
        this.propSupport.firePropertyChange("name", string2, this.name);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.IconFamily.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", SCALABLE_ICON, ICON0, ICON1, ICON2, ICON3};
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("name".equals(string)) {
            return this.getConfigureName();
        }
        if (SCALABLE_ICON.equals(string)) {
            return this.scalablePath;
        }
        if (ICON0.equals(string)) {
            return this.sizePaths[0];
        }
        if (ICON1.equals(string)) {
            return this.sizePaths[1];
        }
        if (ICON2.equals(string)) {
            return this.sizePaths[2];
        }
        if (ICON3.equals(string)) {
            return this.sizePaths[3];
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("name".equals(string)) {
            this.setConfigureName((String)object);
        } else if (SCALABLE_ICON.equals(string)) {
            this.setScalableIconPath((String)object);
        } else if (ICON0.equals(string)) {
            this.setSizeIconPath(0, (String)object);
        } else if (ICON1.equals(string)) {
            this.setSizeIconPath(1, (String)object);
        } else if (ICON2.equals(string)) {
            this.setSizeIconPath(2, (String)object);
        } else if (ICON3.equals(string)) {
            this.setSizeIconPath(3, (String)object);
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    @Override
    public Configurer getConfigurer() {
        return new IconFamilyConfig(this);
    }

    static class FamilyImageFilter
    extends ImageFileFilter {
        private String familyName;

        public FamilyImageFilter(String string) {
            this.familyName = string;
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                String string = file.getName().split("\\.")[0];
                return string.equals(this.familyName);
            }
            return false;
        }
    }

    static class IconImageConfigurer
    extends Configurer {
        protected int size;
        protected JPanel controls;
        protected IconFamily family;
        protected int px;
        protected JLabel warningLabel;

        public IconImageConfigurer(IconFamily iconFamily, int n) {
            super(null, null);
            this.size = n;
            this.family = iconFamily;
            this.px = n < 0 ? SIZES[3] : SIZES[n];
        }

        public IconImageConfigurer(IconFamily iconFamily) {
            this(iconFamily, -1);
        }

        public Component getControls() {
            if (this.controls == null) {
                this.controls = new JPanel(new MigLayout());
                this.controls.add(new JLabel(this.getName()));
                final JPanel jPanel = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    public void paint(Graphics graphics) {
                        graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
                        Icon icon = IconImageConfigurer.this.getIconValue();
                        if (icon != null) {
                            icon.paintIcon(this, graphics, this.getSize().width / 2 - icon.getIconWidth() / 2, this.getSize().height / 2 - icon.getIconHeight() / 2);
                        }
                    }
                };
                jPanel.setPreferredSize(new Dimension(this.px, this.px));
                this.controls.add(jPanel);
                JButton jButton = new JButton(Resources.getString("General.select"));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        IconImageConfigurer.this.selectImage();
                        jPanel.repaint();
                    }
                });
                this.controls.add((Component)jButton, "wrap");
                this.warningLabel = new JLabel();
                this.warningLabel.setForeground(Color.red);
                this.warningLabel.setVisible(false);
                this.checkIconSize();
                this.controls.add((Component)this.warningLabel, "span,wrap");
            }
            return this.controls;
        }

        public String getValueString() {
            if (this.size < 0) {
                return this.family.scalablePath;
            }
            return this.family.sizePaths[this.size];
        }

        public Icon getIconValue() {
            Icon icon = null;
            if (this.family != null) {
                if (this.size < 0) {
                    if (this.family.scalablePath != null) {
                        icon = this.family.getScalableIcon();
                    }
                } else if (this.family.sizePaths[this.size] != null) {
                    icon = this.family.getIcon(this.size);
                }
            }
            return icon;
        }

        public void setValue(String string) {
            if (this.size < 0) {
                this.family.setScalableIconPath(this.buildPath(string));
            } else {
                this.family.setSizeIconPath(this.size, this.buildPath(string));
                this.checkIconSize();
            }
        }

        protected void checkIconSize() {
            Icon icon = this.family.getRawIcon(this.size);
            if (icon != null && icon.getIconHeight() != SIZES[this.size]) {
                this.setWarning(Resources.getString("Editor.IconFamily.size_warning", SIZES[this.size], icon.getIconHeight()));
            }
        }

        protected String buildPath(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            if (this.size < 0) {
                return "icons/scalable/" + string;
            }
            return "icons/" + SIZE_DIRS[this.size] + string;
        }

        protected void setWarning(String string) {
            this.warningLabel.setText(string);
            this.warningLabel.setVisible(string != null && string.length() > 0);
            this.repack();
        }

        protected void repack() {
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
        }

        protected void selectImage() {
            FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
            fileChooser.setFileFilter(new FamilyImageFilter(this.family.getName()));
            fileChooser.setSelectedFile(new File(this.family.getName() + ".*"));
            if (fileChooser.showOpenDialog(this.getControls()) != 0) {
                this.setWarning("");
                this.setValue(null);
            } else {
                File file = fileChooser.getSelectedFile();
                if (file != null && file.exists()) {
                    String string = file.getName();
                    if (string.split("\\.").length != 2) {
                        this.showError(Resources.getString("Editor.IconFamily.illegal_icon_name"));
                    } else if (!string.startsWith(this.family.getName())) {
                        this.showError(Resources.getString("Editor.IconFamily.bad_icon_name", this.family.getName()));
                    } else if (!ImageUtils.hasImageSuffix(string)) {
                        this.showError(Resources.getString("Editor.IconFamily.bad_icon_file"));
                    } else {
                        GameModule.getGameModule().getArchiveWriter().addImage(file.getPath(), this.buildPath(file.getName()));
                        this.setWarning("");
                        this.setValue(string);
                    }
                } else {
                    this.setWarning("");
                    this.setValue(null);
                }
            }
        }

        protected void showError(String string) {
            Dialogs.showMessageDialog(SwingUtilities.getWindowAncestor(this.controls), Resources.getString("Editor.IconFamily.icon_load_error"), Resources.getString("Editor.IconFamily.cannot_load_icon"), string, 0);
        }
    }

    static class IconFamilyConfig
    extends Configurer {
        protected IconFamily family;
        protected JPanel controls;
        protected StringConfigurer title;
        protected JLabel errorLabel;
        protected ImageConfigurer scalableConfig;

        public IconFamilyConfig(IconFamily iconFamily) {
            super(null, null);
            this.family = iconFamily;
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            JPanel jPanel = new JPanel(new MigLayout("inset 5"));
            this.title = new StringConfigurer(null, "", this.family.getConfigureName());
            this.title.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        IconFamilyConfig.this.family.setConfigureName((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
            jPanel.add(new JLabel(Resources.getString("Editor.IconFamily.family_name")));
            jPanel.add(this.title.getControls(), "wrap");
            this.errorLabel = new JLabel(Resources.getString("Editor.IconFamily.name_taken"));
            this.errorLabel.setForeground(Color.red);
            this.errorLabel.setVisible(false);
            this.family.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        IconFamily iconFamily = IconFactory.getIconFamily(IconFamilyConfig.this.family.getName());
                        IconFamilyConfig.this.errorLabel.setVisible(iconFamily != null && iconFamily != IconFamilyConfig.this.family);
                    }
                }
            });
            jPanel.add((Component)this.errorLabel, "span 2,wrap");
            IconImageConfigurer iconImageConfigurer = new IconImageConfigurer(this.family);
            jPanel.add(new JLabel(Resources.getString("Editor.IconFamily.scalable_icon_label")));
            jPanel.add(iconImageConfigurer.getControls(), "wrap");
            IconImageConfigurer[] iconImageConfigurerArray = new IconImageConfigurer[4];
            for (int i = 0; i < 4; ++i) {
                iconImageConfigurerArray[i] = new IconImageConfigurer(this.family, i);
                String string = String.valueOf(SIZES[i]);
                jPanel.add(new JLabel(Resources.getString("Editor.IconFamily.icon_label", IconFamily.getIconSizeNames()[i], string)));
                jPanel.add(iconImageConfigurerArray[i].getControls(), "wrap");
            }
            this.controls.add(jPanel);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }
    }
}

