/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.concurrent.DaemonThreadFactory;
import VASSAL.tools.io.InputOutputStreamPump;
import VASSAL.tools.io.InputStreamPump;
import VASSAL.tools.io.ProcessCallable;
import VASSAL.tools.io.ProcessWrapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLauncher {
    private static final Logger logger = LoggerFactory.getLogger(ProcessLauncher.class);
    protected final ExecutorService exec;

    public ProcessLauncher() {
        this(Executors.newCachedThreadPool(new DaemonThreadFactory(ProcessLauncher.class.getSimpleName())));
    }

    ProcessLauncher(ExecutorService executorService) {
        this.exec = executorService;
    }

    public ProcessWrapper launch(String ... stringArray) throws IOException {
        return this.launch(null, System.out, System.err, stringArray);
    }

    public ProcessWrapper launch(File file, OutputStream outputStream, OutputStream outputStream2, String ... stringArray) throws IOException {
        InputOutputStreamPump inputOutputStreamPump = new InputOutputStreamPump(null, outputStream);
        InputOutputStreamPump inputOutputStreamPump2 = new InputOutputStreamPump(null, outputStream2);
        return this.launch(null, inputOutputStreamPump, inputOutputStreamPump2, stringArray);
    }

    public ProcessWrapper launch(File file, InputStreamPump inputStreamPump, InputStreamPump inputStreamPump2, String ... stringArray) throws IOException {
        logger.info("launching " + StringUtils.join((Object[])stringArray, (char)' '));
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.directory(file);
        Process process = processBuilder.start();
        ProcessCallable processCallable = new ProcessCallable(process, inputStreamPump, inputStreamPump2, this.exec);
        Future<Integer> future = this.exec.submit(processCallable);
        return new ProcessWrapper(future, process.getInputStream(), process.getErrorStream(), process.getOutputStream());
    }
}

