/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.opcache;

import VASSAL.tools.opcache.Op;
import VASSAL.tools.opcache.OpCache;
import VASSAL.tools.opcache.OpObserver;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpImpl<V>
implements Op<V> {
    protected final OpCache cache;
    private static final ConcurrentMap<Op<?>, OpCache.Key<?>> kcache = new ConcurrentHashMap();

    public AbstractOpImpl(OpCache opCache) {
        this.cache = opCache;
    }

    @Override
    public abstract List<Op<?>> getSources();

    @Override
    public abstract V eval() throws Exception;

    public V get() {
        return this.cache.get(this.newKey());
    }

    public V get(OpObserver<V> opObserver) throws CancellationException, InterruptedException, ExecutionException {
        return this.cache.get(this.newKey(), opObserver);
    }

    public Future<V> getFuture(OpObserver<V> opObserver) throws ExecutionException {
        return this.cache.getFuture(this.newKey(), opObserver);
    }

    @Override
    public OpCache.Key<V> newKey() {
        OpCache.Key key;
        OpCache.Key key2 = (OpCache.Key)kcache.get(this);
        if (key2 == null && (key2 = kcache.putIfAbsent(this, key = new OpCache.Key(this, 0))) == null) {
            key2 = key;
        }
        return key2;
    }

    @Override
    public void update() {
        OpCache.Key key = (OpCache.Key)kcache.get(this);
        if (key != null) {
            OpCache.Key key2 = new OpCache.Key(this, key.version + 1);
            kcache.replace(this, key, key2);
        }
    }
}

