/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ANVLRecord {
    public static final String CRLF = "\r\n";
    protected List<String> list = new LinkedList<String>();
    protected Map<String, String> map = new HashMap<String, String>();

    public void addLabelValue(String name, String value) {
        int c = -1;
        if (value == null) {
            throw new IllegalArgumentException("Invalid value!");
        }
        if (value.length() > 0) {
            c = value.charAt(0);
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid name!");
        }
        if (c != -1 && c != 32 && c != 9) {
            this.list.add(name + ": " + value);
        } else {
            this.list.add(name + ":" + value);
        }
        this.map.put(name, value);
    }

    public void addValue(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Invalid value!");
        }
        this.list.add(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = this.list.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.toString().getBytes(charsetName);
    }

    public byte[] getUTF8Bytes() throws UnsupportedEncodingException {
        return this.getBytes("UTF-8");
    }

    public ANVLRecord parse() {
        return null;
    }
}

