{- |
Implementations of 'Ix' methods in terms of 'Enum' methods.

For a type @T@ of class 'Enum' you can easily define an 'Ix' instance
by copying the following code into your module:

>import qualified Data.Ix.Enum as IxEnum
>
>instance Ix T where
>   range           = IxEnum.range
>   index           = IxEnum.index
>   inRange         = IxEnum.inRange
>   rangeSize       = IxEnum.rangeSize
>   unsafeIndex     = IxEnum.unsafeIndex
>   unsafeRangeSize = IxEnum.unsafeRangeSize

-}
module Data.Ix.Enum where

{-# INLINE range #-}
{-# INLINE index #-}
{-# INLINE unsafeIndex #-}
{-# INLINE inRange #-}
{-# INLINE rangeSize #-}
{-# INLINE unsafeRangeSize #-}

range :: Enum a => (a, a) -> [a]
index :: Enum a => (a, a) -> a -> Int
unsafeIndex :: Enum a => (a, a) -> a -> Int
inRange :: Enum a => (a, a) -> a -> Bool
rangeSize :: Enum a => (a, a) -> Int
unsafeRangeSize :: Enum a => (a, a) -> Int

range (l,r) = map toEnum $ range (fromEnum l, fromEnum r)
index (l,r) i = index (fromEnum l, fromEnum r) (fromEnum i)
unsafeIndex (l,r) i = unsafeIndex (fromEnum l, fromEnum r) (fromEnum i)
inRange (l,r) i = inRange (fromEnum l, fromEnum r) (fromEnum i)
rangeSize (l,r) = rangeSize (fromEnum l, fromEnum r)
unsafeRangeSize (l,r) = unsafeRangeSize (fromEnum l, fromEnum r)
