// https://www.securityfocus.com/archive/1/312869 --- originally by Richard Kettlewell
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>

#include "zbuild.h"
#ifdef ZLIB_COMPAT
#  include "zlib.h"
#else
#  include "zlib-ng.h"
#endif

#include <gtest/gtest.h>

#if !defined(_WIN32) && defined(ZLIB_COMPAT)
TEST(gzip, cve_2003_0107) {
    gzFile f;
    int ret;

    f = gzopen("/dev/null", "w");
    EXPECT_TRUE(f != NULL);

    ret = gzprintf(f, "%10240s", "");
    printf("gzprintf -> %d\n", ret);
    ret = gzclose(f);
    printf("gzclose -> %d [%d]\n", ret, errno);
}
#endif
