/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Year;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiParameter;

public class PhpAPIGenerator
extends AbstractAPIGenerator {
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-php/src/Zap/";
    private final String HEADER = "<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright " + Year.now() + " the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public PhpAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public PhpAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public PhpAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    private void generatePhpElement(ApiElement element, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        block12: {
            hasParams = !element.getParameters().isEmpty();
            String descTag = element.getDescriptionTag();
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("\t/**\n");
                out.write("\t * " + desc + "\n");
                if (this.isOptional()) {
                    out.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                out.write("\t */\n");
            }
            catch (Exception e2) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block12;
                out.write("\t/**\n");
                out.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                out.write("\t */\n");
            }
        }
        out.write("\tpublic function " + PhpAPIGenerator.createMethodName(element.getName()) + "(");
        out.write(element.getParameters().stream().map(parameter -> {
            String varName = "$" + parameter.getName().toLowerCase(Locale.ROOT);
            if (parameter.isRequired()) {
                return varName;
            }
            return varName + "=NULL";
        }).collect(Collectors.joining(", ")));
        if (hasParams) {
            out.write(", ");
        }
        out.write("$apikey='') {\n");
        StringBuilder reqParams = new StringBuilder();
        reqParams.append("array(");
        String params = element.getParameters().stream().filter(ApiParameter::isRequired).map(parameter -> {
            String name = parameter.getName();
            return "'" + name + "' => $" + name.toLowerCase(Locale.ROOT);
        }).collect(Collectors.joining(", "));
        reqParams.append(params);
        boolean first = params.isEmpty();
        if (!first) {
            reqParams.append(", ");
        }
        reqParams.append("'").append("apikey").append("' => $").append("apikey").append(")");
        List optionalParameters = element.getParameters().stream().filter(e -> !e.isRequired()).collect(Collectors.toList());
        if (!optionalParameters.isEmpty()) {
            out.write("\t\t$params = ");
            out.write(reqParams.toString());
            out.write(";\n");
            reqParams.replace(0, reqParams.length(), "$params");
            for (ApiParameter parameter2 : optionalParameters) {
                String name = parameter2.getName();
                String varName = name.toLowerCase(Locale.ROOT);
                out.write("\t\tif ($" + varName + " !== NULL) {\n");
                out.write("\t\t\t$params['" + name + "'] = $" + varName + ";\n");
                out.write("\t\t}\n");
            }
        }
        Object method = "request";
        Object baseUrl = "base";
        if (type.equals("other")) {
            method = (String)method + "Other";
            baseUrl = (String)baseUrl + "_other";
        }
        out.write("\t\treturn $this->zap->" + (String)method + "($this->zap->" + (String)baseUrl + " . '" + component + "/" + type + "/" + element.getName() + "/'");
        out.write(", ");
        out.write(reqParams.toString());
        out.write(")");
        if (type.equals("view")) {
            if (element.getName().startsWith("option")) {
                out.write("->{'" + element.getName().substring(6) + "'};\n");
            } else {
                out.write("->{'" + element.getName() + "'};\n");
            }
        } else {
            out.write(";\n");
        }
        out.write("\t}\n\n");
    }

    private static String createMethodName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return PhpAPIGenerator.removeAllFullStopCharacters(name);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = PhpAPIGenerator.safeName(imp.getPrefix().substring(0, 1).toUpperCase() + imp.getPrefix().substring(1));
        Path file = this.getDirectory().resolve(className + ".php");
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(this.HEADER);
            out.write("namespace Zap;\n\n");
            out.write("\n");
            out.write("/**\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" * @property Zap $zap\n");
            out.write(" */\n");
            out.write("class " + className + " {\n\n");
            out.write("\tpublic function __construct ($zap) {\n");
            out.write("\t\t$this->zap = $zap;\n");
            out.write("\t}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generatePhpElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generatePhpElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generatePhpElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("}\n");
        }
    }

    private static String safeName(String name) {
        if (nameMap.containsKey(name)) {
            return nameMap.get(name);
        }
        return name;
    }

    public static void main(String[] args) throws Exception {
        PhpAPIGenerator wapi = new PhpAPIGenerator();
        wapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("Break", "Brk");
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

