/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptsCache<T> {
    private final ExtensionScript extensionScript;
    private final Configuration<T> config;
    private final InterfaceProvider<T> interfaceProvider;
    private final Map<ScriptWrapper, CachedScript<T>> cache;
    private List<CachedScript<T>> cachedScripts;

    ScriptsCache(ExtensionScript extensionScript, Configuration<T> config) {
        this.extensionScript = extensionScript;
        this.config = config;
        this.interfaceProvider = config.getInterfaceProvider() == null ? this.createDefaultInterfaceProvider() : config.getInterfaceProvider();
        this.cache = Collections.synchronizedMap(new HashMap());
        this.cachedScripts = Collections.emptyList();
    }

    private InterfaceProvider<T> createDefaultInterfaceProvider() {
        return (scriptWrapper, targetInterface) -> {
            Object script = this.extensionScript.getInterface(scriptWrapper, targetInterface);
            if (script == null) {
                this.extensionScript.handleFailedScriptInterface(scriptWrapper, this.config.getInterfaceErrorMessageProvider().getErrorMessage(scriptWrapper));
            }
            return script;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map<ScriptWrapper, CachedScript<T>> map = this.cache;
        synchronized (map) {
            List<ScriptWrapper> latestScripts = this.extensionScript.getScripts(this.config.getScriptType());
            this.cache.keySet().retainAll(latestScripts);
            ArrayList latestCachedScripts = new ArrayList();
            latestScripts.forEach(scriptWrapper -> this.refreshScriptImpl((ScriptWrapper)scriptWrapper, latestCachedScripts));
            this.cachedScripts = Collections.unmodifiableList(latestCachedScripts);
        }
    }

    private void refreshScriptImpl(ScriptWrapper scriptWrapper, List<CachedScript<T>> latestCachedScripts) {
        CachedScript cachedScript = this.cache.computeIfAbsent(scriptWrapper, CachedScript::new);
        if (!cachedScript.isEnabled()) {
            cachedScript.setScript(null);
            return;
        }
        if (!cachedScript.hasChanged()) {
            latestCachedScripts.add(cachedScript);
            return;
        }
        cachedScript.setScript(null);
        try {
            T script = this.interfaceProvider.getInterface(scriptWrapper, this.config.getTargetInterface());
            if (script != null) {
                cachedScript.setScript(script);
                latestCachedScripts.add(cachedScript);
            }
        }
        catch (Exception e) {
            this.extensionScript.handleScriptException(scriptWrapper, e);
        }
    }

    public void execute(ScriptAction<T> action) {
        this.cachedScripts.forEach(e -> {
            try {
                e.execute(() -> {
                    action.apply(e.getScript());
                    return null;
                });
            }
            catch (Exception ex) {
                this.extensionScript.handleScriptException(e.getScriptWrapper(), ex);
            }
        });
    }

    public void refreshAndExecute(ScriptAction<T> action) {
        this.refresh();
        this.execute(action);
    }

    public void execute(ScriptWrapperAction<T> action) {
        this.cachedScripts.forEach(e -> {
            ScriptWrapper sw = e.getScriptWrapper();
            try {
                ExtensionScript.recordScriptCalledStats(sw);
                e.execute(() -> {
                    action.apply(sw, e.getScript());
                    return null;
                });
            }
            catch (Exception ex) {
                this.extensionScript.handleScriptException(sw, ex);
            }
        });
    }

    public void refreshAndExecute(ScriptWrapperAction<T> action) {
        this.refresh();
        this.execute(action);
    }

    public List<CachedScript<T>> getCachedScripts() {
        return this.cachedScripts;
    }

    public static interface InterfaceErrorMessageProvider {
        public String getErrorMessage(ScriptWrapper var1);
    }

    public static interface InterfaceProvider<T> {
        public T getInterface(ScriptWrapper var1, Class<T> var2) throws Exception;
    }

    public static interface ScriptWrapperAction<T> {
        public void apply(ScriptWrapper var1, T var2) throws Exception;
    }

    public static interface ScriptAction<T> {
        public void apply(T var1) throws Exception;
    }

    public static class Configuration<T> {
        private final String scriptType;
        private final Class<T> targetInterface;
        private final InterfaceProvider<T> interfaceProvider;
        private final InterfaceErrorMessageProvider interfaceErrorMessageProvider;

        private Configuration(String scriptType, Class<T> targetInterface, InterfaceProvider<T> interfaceProvider, InterfaceErrorMessageProvider interfaceErrorMessageProvider) {
            this.scriptType = scriptType;
            this.targetInterface = targetInterface;
            this.interfaceProvider = interfaceProvider;
            this.interfaceErrorMessageProvider = interfaceErrorMessageProvider;
        }

        public String getScriptType() {
            return this.scriptType;
        }

        public Class<T> getTargetInterface() {
            return this.targetInterface;
        }

        public InterfaceProvider<T> getInterfaceProvider() {
            return this.interfaceProvider;
        }

        public InterfaceErrorMessageProvider getInterfaceErrorMessageProvider() {
            return this.interfaceErrorMessageProvider;
        }

        public static <T1> Builder<T1> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private String scriptType;
            private Class<T> targetInterface;
            private InterfaceProvider<T> interfaceProvider;
            private InterfaceErrorMessageProvider interfaceErrorMessageProvider;

            private Builder() {
            }

            public Builder<T> setScriptType(String scriptType) {
                this.scriptType = scriptType;
                return this;
            }

            public Builder<T> setTargetInterface(Class<T> targetInterface) {
                this.targetInterface = targetInterface;
                return this;
            }

            public Builder<T> setInterfaceProvider(InterfaceProvider<T> interfaceProvider) {
                this.interfaceProvider = interfaceProvider;
                return this;
            }

            public Builder<T> setInterfaceErrorMessageProvider(InterfaceErrorMessageProvider interfaceErrorMessageProvider) {
                this.interfaceErrorMessageProvider = interfaceErrorMessageProvider;
                return this;
            }

            public final Configuration<T> build() {
                if (this.scriptType == null || this.scriptType.isEmpty()) {
                    throw new IllegalStateException("The script type must be set.");
                }
                if (this.targetInterface == null) {
                    throw new IllegalStateException("The target interface must be set.");
                }
                if (this.interfaceProvider != null && this.interfaceErrorMessageProvider != null) {
                    throw new IllegalStateException("The interface error message provider must not be set if using an interface provider.");
                }
                return new Configuration<T>(this.scriptType, this.targetInterface, this.interfaceProvider, this.interfaceErrorMessageProvider);
            }
        }
    }

    public static class CachedScript<T> {
        private final ScriptWrapper scriptWrapper;
        private int currentModCount;
        private T script;

        CachedScript(ScriptWrapper scriptWrapper) {
            this.scriptWrapper = scriptWrapper;
            this.currentModCount = scriptWrapper.getModCount();
        }

        public ScriptWrapper getScriptWrapper() {
            return this.scriptWrapper;
        }

        public T getScript() {
            return this.script;
        }

        void setScript(T script) {
            this.script = script;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(Callable<T> action) throws Exception {
            if (this.isSyncAccess()) {
                CachedScript cachedScript = this;
                synchronized (cachedScript) {
                    action.call();
                }
            } else {
                action.call();
            }
        }

        private boolean isSyncAccess() {
            ScriptEngineWrapper engine = this.scriptWrapper.getEngine();
            return engine != null && engine.isSingleThreaded();
        }

        boolean hasChanged() {
            if (this.script == null) {
                return true;
            }
            int previousModCount = this.currentModCount;
            this.currentModCount = this.scriptWrapper.getModCount();
            return previousModCount != this.currentModCount;
        }

        boolean isEnabled() {
            return this.scriptWrapper.isEnabled();
        }
    }
}

