/*
 * Table.java
 *
 * Created on 31 de julio de 2002, 09:58
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class Table extends DBObject {
    private long pages_number = 0;
    private Vector columns = null;
    private Vector index = null;
    
    /** Creates a new instance of Table */
    public Table(DBObject owner, long oid) {
        super(owner);
        search(oid);
    }
    public Table(DBObject owner) {
        super(owner);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        return new String();
        
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE TABLE ");
        retorno.append(getName());
        retorno.append(" ( \n\t");
        for(int i=0; i<getColumns().size(); i++){
            TableColumn tc = (TableColumn) getColumns().get(i);
            retorno.append(tc.getInsertSQL());
            retorno.append(", \n\t");
        }
        
        Vector tmp = getPrimaryKeys();
        for(int i=0; i<tmp.size(); i++){
            retorno.append(((TableIndex) tmp.get(i)).getInsertSQL());
        }
        
        retorno.append(" );\n");
        
        tmp = getNotPrimaryKeyIndex();
        for(int i=0; i<tmp.size(); i++){
            retorno.append(((TableIndex) tmp.get(i)).getInsertSQL());
            retorno.append("\n");
        }
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the OID.
     * @param _oid OID to search.
     * @return true if the object was found
     */
    public boolean search(long _oid) {
        boolean retorno = false;
        try{
            initialize();
            PreparedStatement prep = getConnection().prepareStatement("SELECT OID, * FROM PG_CLASS WHERE OID=?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if(rs.next()){
                setName(rs.getString("RELNAME"));
                setOID(rs.getLong("OID"));
                setNumberOfPages(rs.getLong("RELPAGES"));
                setCreator(new User(this, rs.getLong("RELOWNER")));
                retorno = true;
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        pages_number = 0;
        columns = null;
        index = null;
    }
    
    public dataSource getColumnsTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        
        Vector temp = getColumns();
        for(int i=0; i<temp.size(); i++){
            TableColumn tc = (TableColumn) temp.get(i);
            
            Vector elem = new Vector();
            elem.add(String.valueOf(tc.getColumnNumber()));
            elem.add(tc.getName());
            elem.add(tc.getColumnType().getName());
            elem.add(String.valueOf(tc.getSize()));
            elem.add(Utilities.formatBoolean(tc.allowNulls()));
            elem.add(tc.getDefaultValue());
            elem.add(tc.getDescription());
            
            dsve.addElement(elem);
        }
        return dsve;
    }
    public dataSource getIndexTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Name");
        dsve.addColumnName("Primary");
        dsve.addColumnName("Unique");
        dsve.addColumnName("Cluster");
        dsve.addColumnName("Columns");
        dsve.addColumnSize(20);
        dsve.addColumnSize(6);
        dsve.addColumnSize(6);
        dsve.addColumnSize(6);
        dsve.addColumnSize(30);
        
        Vector temp = getIndexes();
        for(int i=0; i<temp.size(); i++){
            TableIndex ti = (TableIndex) index.get(i);
            
            Vector elem = new Vector();
            elem.add(ti.getName());
            elem.add(Utilities.formatBoolean(ti.isPrimary()));
            elem.add(Utilities.formatBoolean(ti.isUnique()));
            elem.add(Utilities.formatBoolean(ti.isClustered()));
            elem.add(ti.getColumnsText());
            dsve.addElement(elem);
        }
        return dsve;
    }
    
    // -------SET AND GET ----------
    private void setNumberOfPages(long _pages_number){
        pages_number = _pages_number;
    }
    public long getNumberOfPages(){
        return pages_number;
    }
    
    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();
            try{
                PreparedStatement prep = getConnection().prepareStatement("select "
                + " ATTNUM from pg_attribute "
                + "  where attnum > 0 and  attrelid = ? ORDER BY attnum");
                prep.setLong(1, getOID());
                ResultSet rs = prep.executeQuery();
                while(rs.next()){
                    TableColumn tc = new TableColumn(this, rs.getLong("ATTNUM"));
                    columns.add(tc);
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return columns;
    }
    
    private Vector getIndexes(){
        if(index == null){
            index = new Vector();
            try{
                PreparedStatement prep = getConnection().prepareStatement("select "
                + "indexrelid as oid from pg_index   where indrelid = ?");
                prep.setLong(1, getOID());
                ResultSet rs = prep.executeQuery();
                while(rs.next()){
                    TableIndex ti = new TableIndex(this, rs.getLong("OID"));
                    index.add(ti);
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
            }
        }
        return index;
    }
    public Vector getPrimaryKeys(){
        Vector retorno = new Vector();
        Vector tmp = getIndexes();
        for(int i=0;i < tmp.size(); i++){
            if(((TableIndex) tmp.get(i)).isPrimary()){
                retorno.add(tmp.get(i));
            }
        }
        return retorno;
    }
    public Vector getNotPrimaryKeyIndex(){
        Vector retorno = new Vector();
        Vector tmp = getIndexes();
        for(int i=0;i < tmp.size(); i++){
            if(!((TableIndex) tmp.get(i)).isPrimary()){
                retorno.add(tmp.get(i));
            }
        }
        return retorno;
    }
}
