#include "util.h"
#include "def.h"

#include <uuid.h>

int uuid_generate_time(uuid_p out)
{
	static unsigned char node_mac[6];
	static int has_init = 0;
	
	uuid_u32_t clock_mid;

	if (!has_init) {
		if (get_if_mac(IF_NUMBER, node_mac) < 0) {
			get_random_buffer(node_mac, 6);
			/*
			 * Set multicast bit, to prevent conflicts
			 * with IEEE 802 addresses obtained from
			 * network cards
			 */
			node_mac[0] |= 0x80;
		}
		has_init = 1;
	}
	get_clock(&clock_mid, &(out->time_low), &(out->clock_seq));

	out->clock_seq |= 0x8000;
	out->time_mid = (uuid_u16_t) clock_mid;
	out->time_hi_and_version = (clock_mid >> 16) | 0x1000;

	memcpy(out->node, node_mac, 6);

	return (0);
}
