/*-------------------------------------------------------------------------
 *
 * FILE
 *    in_out.c
 *
 * DESCRIPTION
 *   UUID type input and output routine
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 *
 * $Header: /usr/local/cvsroot/pguuid/pguuid/src/in_out.c,v 1.4 2003/06/11 05:42:12 xylophone Exp $
 *
 *-------------------------------------------------------------------------
 */
#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>

/* in func */
PG_FUNCTION_INFO_V1(uuid_in);
Datum uuid_in(PG_FUNCTION_ARGS)
{
	uuid_p result;

	const char* in = PG_GETARG_CSTRING(0);
	result = (uuid_p)palloc(sizeof(uuid_t));

	if(uuid_parse(in, result) < 0)
	{
		elog(ERROR, "%s is invalid UUID format!", in);
	}

	PG_RETURN_POINTER(result);
}

/* out func */
PG_FUNCTION_INFO_V1(uuid_out);
Datum uuid_out(PG_FUNCTION_ARGS)
{
	char* result = 0;

	uuid_p ptr = (uuid_p) PG_GETARG_POINTER(0);
	result = (char*)palloc(sizeof(char) * 36);

	uuid_unparse(ptr, result);

	PG_RETURN_CSTRING(result);
}
