#include "util.h"

#include <uuid.h>

#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>

int get_if_mac(int if_number, unsigned char if_mac[])
{
	static int has_mac = 0;

	int	sd;
	struct ifreq ifr;

	static unsigned char a[6] = {0};
	
	if (has_mac == -1)
	{
		return (-1);
	}

	if (has_mac == 0)
	{
		snprintf(ifr.ifr_name, 10,  "eth%d", if_number);
	
		sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
		if (sd < 0)
		{
			memset(if_mac, 0, 6);
			has_mac = -1;

			return (-1);
		}

		if (ioctl(sd, SIOCGIFHWADDR, &ifr) < 0)
		{
			memset(if_mac, 0, 6);
			has_mac = -1;

			return (-1);
		}

		close(sd);

		memcpy(a, (unsigned char *) &ifr.ifr_hwaddr.sa_data, 6);
	
		has_mac = 1;
	}	
	memcpy(if_mac, a, 6);

	return (0);
}
