/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobValue
extends Reader
implements Clob {
    private final Reader m_reader;
    private final long m_nChars;
    private long m_readerPos;
    private long m_markPos;

    public ClobValue(String string) {
        this(new StringReader(string), string.length());
    }

    public ClobValue(Reader reader, long l) {
        this.m_reader = reader;
        this.m_nChars = l;
        this.m_readerPos = 0L;
        this.m_markPos = 0L;
    }

    public long length() {
        return this.m_nChars;
    }

    public InputStream getAsciiStream() {
        return new BufferedInputStream(new InputStream(this){
            private /* synthetic */ ClobValue this$0;
            {
                this.this$0 = clobValue;
            }

            public int read() throws IOException {
                int n = this.this$0.read();
                if (n > 127) {
                    throw new CharConversionException("Non ascii character in Clob data");
                }
                return n;
            }
        });
    }

    public Reader getCharacterStream() {
        return this;
    }

    public String getSubString(long l, int n) throws SQLException {
        if (l < 0L || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return "";
        }
        if (l + (long)n > this.m_nChars) {
            throw new SQLException("Attempt to read beyond end of Clob data");
        }
        long l2 = l - this.m_readerPos;
        if (l2 < 0L) {
            throw new SQLException("Cannot position Clob stream backwards");
        }
        try {
            char[] cArray;
            int n2;
            if (l2 > 0L) {
                this.skip(l2);
            }
            if ((n2 = this.read(cArray = new char[n])) < n) {
                throw new SQLException("Clob data read not fulfilled");
            }
            return new String(cArray);
        }
        catch (IOException iOException) {
            throw new SQLException("Error reading Blob data: " + iOException.getMessage());
        }
    }

    public long position(String string, long l) {
        throw new UnsupportedOperationException();
    }

    public long position(Clob clob, long l) {
        throw new UnsupportedOperationException();
    }

    public OutputStream setAsciiStream(long l) {
        throw new UnsupportedOperationException();
    }

    public Writer setCharacterStream(long l) {
        throw new UnsupportedOperationException();
    }

    public int setString(long l, String string) {
        throw new UnsupportedOperationException();
    }

    public int setString(long l, String string, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public void truncate(long l) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.m_reader.close();
        this.m_readerPos = 0L;
        this.m_markPos = 0L;
    }

    public boolean markSupported() {
        return this.m_reader.markSupported();
    }

    public synchronized void mark(int n) throws IOException {
        this.m_reader.mark(n);
        this.m_markPos = this.m_readerPos;
    }

    public synchronized int read() throws IOException {
        int n = this.m_reader.read();
        ++this.m_readerPos;
        return n;
    }

    public synchronized int read(char[] cArray) throws IOException {
        int n = this.m_reader.read(cArray);
        this.m_readerPos += (long)n;
        return n;
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.m_reader.read(cArray, n, n2);
        this.m_readerPos += (long)n3;
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = this.m_reader.skip(l);
        this.m_readerPos += l2;
        return l2;
    }

    public synchronized boolean ready() throws IOException {
        return this.m_reader.ready();
    }

    public synchronized void reset() throws IOException {
        this.m_reader.reset();
        this.m_readerPos = this.m_markPos;
    }
}

