/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PG_Stream;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.Serialize;
import org.postgresql.util.UnixCrypt;

public abstract class Connection {
    public PG_Stream pg_stream;
    private String PG_HOST;
    private int PG_PORT;
    private String PG_USER;
    private String PG_PASSWORD;
    private String PG_DATABASE;
    private boolean PG_STATUS;
    private String encoding;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    protected static final int PG_PROTOCOL_LATEST_MAJOR = 2;
    protected static final int PG_PROTOCOL_LATEST_MINOR = 0;
    private static final int SM_DATABASE = 64;
    private static final int SM_USER = 32;
    private static final int SM_OPTIONS = 64;
    private static final int SM_UNUSED = 64;
    private static final int SM_TTY = 64;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private String salt;
    public Hashtable fieldCache = new Hashtable();
    public SQLWarning firstWarning = null;
    public int pid;
    public int ckey;
    byte[] receive_sbuf = new byte[8192];
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "org.postgresql.geometric.PGbox"}, {"circle", "org.postgresql.geometric.PGcircle"}, {"line", "org.postgresql.geometric.PGline"}, {"lseg", "org.postgresql.geometric.PGlseg"}, {"path", "org.postgresql.geometric.PGpath"}, {"point", "org.postgresql.geometric.PGpoint"}, {"polygon", "org.postgresql.geometric.PGpolygon"}, {"money", "org.postgresql.util.PGmoney"}};

    protected void openConnection(String string, int n, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        String string4;
        Object object;
        int n2;
        if (properties.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user");
        }
        if (properties.getProperty("password") == null) {
            throw new PSQLException("postgresql.con.pass");
        }
        this.this_driver = driver;
        this.this_url = string3;
        this.PG_DATABASE = string2;
        this.PG_PASSWORD = properties.getProperty("password");
        this.PG_USER = properties.getProperty("user");
        this.PG_PORT = n;
        this.PG_HOST = string;
        this.PG_STATUS = this.CONNECTION_BAD;
        try {
            this.pg_stream = new PG_Stream(string, n);
        }
        catch (ConnectException connectException) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.con.failed", iOException);
        }
        try {
            this.pg_stream.SendInteger(296, 4);
            this.pg_stream.SendInteger(2, 2);
            this.pg_stream.SendInteger(0, 2);
            this.pg_stream.Send(string2.getBytes(), 64);
            this.pg_stream.Send(this.PG_USER.getBytes(), 224);
            this.pg_stream.flush();
            n2 = -1;
            do {
                int n3 = this.pg_stream.ReceiveChar();
                block3 : switch (n3) {
                    case 69: {
                        throw new SQLException(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
                    }
                    case 82: {
                        n2 = this.pg_stream.ReceiveIntegerR(4);
                        if (n2 == 4) {
                            object = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            this.salt = new String((byte[])object, 0, 2);
                            DriverManager.println("Salt=" + this.salt);
                        }
                        switch (n2) {
                            case 0: {
                                break block3;
                            }
                            case 1: {
                                DriverManager.println("postgresql: KRB4");
                                throw new PSQLException("postgresql.con.kerb4");
                            }
                            case 2: {
                                DriverManager.println("postgresql: KRB5");
                                throw new PSQLException("postgresql.con.kerb5");
                            }
                            case 3: {
                                DriverManager.println("postgresql: PASSWORD");
                                this.pg_stream.SendInteger(5 + this.PG_PASSWORD.length(), 4);
                                this.pg_stream.Send(this.PG_PASSWORD.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                break block3;
                            }
                            case 4: {
                                DriverManager.println("postgresql: CRYPT");
                                object = UnixCrypt.crypt(this.salt, this.PG_PASSWORD);
                                this.pg_stream.SendInteger(5 + object.length(), 4);
                                this.pg_stream.Send(object.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                break block3;
                            }
                        }
                        throw new PSQLException("postgresql.con.auth", new Integer(n2));
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail");
                    }
                }
            } while (n2 != 0);
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.con.failed", iOException);
        }
        n2 = this.pg_stream.ReceiveChar();
        switch (n2) {
            case 75: {
                this.pid = this.pg_stream.ReceiveInteger(4);
                this.ckey = this.pg_stream.ReceiveInteger(4);
                break;
            }
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
        }
        n2 = this.pg_stream.ReceiveChar();
        switch (n2) {
            case 90: {
                break;
            }
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
        }
        this.firstWarning = null;
        ResultSet resultSet = this.ExecSQL("set datestyle to 'ISO'; select getdatabaseencoding()");
        object = null;
        if (resultSet.next()) {
            object = resultSet.getString(1);
            object = object.equals("SQL_ASCII") ? "ASCII" : (Object)(object.equals("UNICODE") ? "UTF8" : (Object)(object.equals("LATIN1") ? "ISO8859_1" : (Object)(object.equals("LATIN2") ? "ISO8859_2" : (Object)(object.equals("LATIN3") ? "ISO8859_3" : (Object)(object.equals("LATIN4") ? "ISO8859_4" : (Object)(object.equals("LATIN5") ? "ISO8859_5" : (Object)(object.equals("LATIN6") ? "ISO8859_6" : (Object)(object.equals("LATIN7") ? "ISO8859_7" : (Object)(object.equals("LATIN8") ? "ISO8859_8" : (Object)(object.equals("LATIN9") ? "ISO8859_9" : (Object)(object.equals("EUC_JP") ? "EUC_JP" : (Object)(object.equals("EUC_CN") ? "EUC_CN" : (Object)(object.equals("EUC_KR") ? "EUC_KR" : (Object)(object.equals("EUC_TW") ? "EUC_TW" : (Object)(object.equals("KOI8") ? "KOI8_R" : (Object)(object.equals("WIN") ? "Cp1252" : null))))))))))))))));
        }
        if ((string4 = properties.getProperty("charSet")) != null) {
            this.encoding = string4;
        } else if (object != null) {
            try {
                "TEST".getBytes((String)object);
                this.encoding = object;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.encoding = null;
            }
        } else {
            this.encoding = null;
        }
        this.initObjectTypes();
        this.firstWarning = null;
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public void addWarning(String string) {
        DriverManager.println(string);
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(string));
        } else {
            this.firstWarning = new SQLWarning(string);
        }
    }

    public ResultSet ExecSQL(String string) throws SQLException {
        return this.ExecSQL(string, null);
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet ExecSQL(String var1_1, Statement var2_2) throws SQLException {
        var3_3 = 0;
        if (var2_2 != null) {
            var3_3 = var2_2.getMaxRows();
        }
        var4_4 = this.pg_stream;
        synchronized (var4_4) {
            var5_5 = null;
            var6_6 = new Vector<Object>();
            var7_7 = null;
            var8_8 = 0;
            var9_9 = false;
            var10_10 = null;
            var12_11 = 1;
            var13_12 = 0;
            var14_13 = null;
            if (this.getEncoding() == null) {
                var7_7 = var1_1.getBytes();
            } else {
                try {
                    var7_7 = var1_1.getBytes(this.getEncoding());
                }
                catch (UnsupportedEncodingException var15_14) {
                    throw new PSQLException("postgresql.con.encoding", var15_14);
                }
            }
            try {
                this.pg_stream.SendChar(81);
                this.pg_stream.Send(var7_7);
                this.pg_stream.SendChar(0);
                this.pg_stream.flush();
                if (true) ** GOTO lbl110
            }
            catch (IOException var15_15) {
                throw new PSQLException("postgresql.con.ioerror", var15_15);
            }
            block25: do {
                var15_16 = null;
                var16_18 = this.pg_stream.ReceiveChar();
                switch (var16_18) {
                    case 65: {
                        this.pid = this.pg_stream.ReceiveInteger(4);
                        var11_17 = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
                        break;
                    }
                    case 66: {
                        if (var5_5 == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        var15_16 = this.pg_stream.ReceiveTuple(var5_5.length, true);
                        if (var3_3 != 0 && var6_6.size() >= var3_3) continue block25;
                        var6_6.addElement(var15_16);
                        break;
                    }
                    case 67: {
                        var10_10 = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
                        if (var10_10.startsWith("INSERT") || var10_10.startsWith("UPDATE") || var10_10.startsWith("DELETE")) {
                            try {
                                var12_11 = Integer.parseInt(var10_10.substring(1 + var10_10.lastIndexOf(32)));
                            }
                            catch (NumberFormatException var17_20) {
                                throw new PSQLException("postgresql.con.fathom", (Object)var10_10);
                            }
                            if (var10_10.startsWith("INSERT")) {
                                try {
                                    var13_12 = Integer.parseInt(var10_10.substring(1 + var10_10.indexOf(32), var10_10.lastIndexOf(32)));
                                }
                                catch (NumberFormatException var17_21) {
                                    throw new PSQLException("postgresql.con.fathom", (Object)var10_10);
                                }
                            }
                        }
                        if (var5_5 != null) {
                            var9_9 = true;
                            break;
                        }
                        try {
                            this.pg_stream.SendChar(81);
                            this.pg_stream.SendChar(32);
                            this.pg_stream.SendChar(0);
                            this.pg_stream.flush();
                        }
                        catch (IOException var17_22) {
                            throw new PSQLException("postgresql.con.ioerror", var17_22);
                        }
                        ++var8_8;
                        break;
                    }
                    case 68: {
                        if (var5_5 == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        var15_16 = this.pg_stream.ReceiveTuple(var5_5.length, false);
                        if (var3_3 != 0 && var6_6.size() >= var3_3) continue block25;
                        var6_6.addElement(var15_16);
                        break;
                    }
                    case 69: {
                        var11_17 = this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding());
                        var14_13 = new SQLException(var11_17);
                        var9_9 = true;
                        break;
                    }
                    case 73: {
                        var17_19 = this.pg_stream.ReceiveChar();
                        if (var17_19 != 0) {
                            throw new PSQLException("postgresql.con.garbled");
                        }
                        if (var8_8 > 0) {
                            --var8_8;
                        }
                        if (var8_8 != 0) continue block25;
                        var9_9 = true;
                        break;
                    }
                    case 78: {
                        this.addWarning(this.pg_stream.ReceiveString(this.receive_sbuf, 4096, this.getEncoding()));
                        break;
                    }
                    case 80: {
                        var18_23 = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
                        break;
                    }
                    case 84: {
                        if (var5_5 != null) {
                            throw new PSQLException("postgresql.con.multres");
                        }
                        var5_5 = this.ReceiveFields();
                        break;
                    }
                    case 90: {
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", new Character((char)var16_18));
                    }
                }
lbl110:
                // 15 sources

            } while (!var9_9 || var8_8 > 0);
            if (var14_13 != null) {
                throw var14_13;
            }
            var15_16 = this.getResultSet(this, var2_2, var5_5, var6_6, var10_10, var12_11, var13_12);
            return var15_16;
        }
    }

    private Field[] ReceiveFields() throws SQLException {
        int n = this.pg_stream.ReceiveIntegerR(2);
        Field[] fieldArray = new Field[n];
        int n2 = 0;
        while (n2 < n) {
            String string = this.pg_stream.ReceiveString(this.receive_sbuf, 8192, this.getEncoding());
            int n3 = this.pg_stream.ReceiveIntegerR(4);
            int n4 = this.pg_stream.ReceiveIntegerR(2);
            int n5 = this.pg_stream.ReceiveIntegerR(4);
            fieldArray[n2] = new Field(this, string, n3, n4, n5);
            ++n2;
        }
        return fieldArray;
    }

    public void setCursorName(String string) throws SQLException {
        this.cursor = string;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    public String getEncoding() throws SQLException {
        return this.encoding;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pg_stream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String string, String string2) throws SQLException {
        try {
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.fetch(Integer.parseInt(string2));
            }
            if (v instanceof String) {
                PGobject pGobject = null;
                pGobject = (PGobject)Class.forName((String)v).newInstance();
                pGobject.setType(string);
                pGobject.setValue(string2);
                return pGobject;
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).fetch(Integer.parseInt(string2));
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.creobj", (Object)string, (Object)exception);
        }
        return null;
    }

    public int putObject(Object object) throws SQLException {
        try {
            String string = object.getClass().getName();
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.store(object);
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).store(object);
            }
            throw new PSQLException("postgresql.con.strobj");
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.strobjex", exception);
        }
    }

    public void addDataType(String string, String string2) {
        this.objectTypes.put(string, string2);
    }

    private void initObjectTypes() {
        int n = 0;
        while (n < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[n][0], defaultObjectTypes[n][1]);
            ++n;
        }
    }

    public abstract Statement createStatement() throws SQLException;

    protected abstract ResultSet getResultSet(Connection var1, Statement var2, Field[] var3, Vector var4, String var5, int var6, int var7) throws SQLException;

    public abstract void close() throws SQLException;

    public void finalize() throws Throwable {
        this.close();
    }

    public String EscapeSQL(String string) {
        int n = string.indexOf("{d");
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(n, ' ');
            stringBuffer.setCharAt(n + 1, ' ');
            stringBuffer.setCharAt(string.indexOf(125, n), ' ');
            string = new String(stringBuffer);
            n = string.indexOf("{d");
        }
        return string;
    }
}

