/* $Id: savepoint.c,v 1.5 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/sp.c,v 1.2 2004/12/16 11:21:20 flaw
 * imp/src/sp.c,v 1.1 2004/12/15 13:10:01 flaw
 *//*
 * The Postgres Savepoint interface
 */
#include <postgres.h>
#include <access/heapam.h>
#include <catalog/pg_type.h>
#include <executor/tstoreReceiver.h>
#include <nodes/parsenodes.h>
#include <utils/array.h>
#include <utils/palloc.h>
#include <utils/relcache.h>
#include <pypg/postgres.h>
#include <pypg/environment.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/savepoint.h>
#include <pypg/error.h>

#define SavepointOperable(VAR, STR) \
	List VAR; \
	DefElem VAR##_el; \
	ListCell VAR##_c; \
	Value VAR##_v; \
	VAR##_el.defname = "savepoint_name"; \
	VAR##_el.arg = (void *) &(VAR##_v); \
	VAR##_v.type = T_String; \
	VAR##_v.val.str = STR; \
	VAR##_c.next = NULL; \
	VAR##_c.data.ptr_value = &(VAR##_el); \
	VAR.type = T_List; \
	VAR.length = 1; \
	VAR.head = &(VAR##_c); \
	VAR.tail = &(VAR##_c);

static PyObj
release(PyObj self)
{
	SavepointOperable(sp, PyPgSavepoint_FetchSTRING(self));
	PG_TRY();
	{
		ReleaseSavepoint(&sp);
		CommitTransactionCommand();
	}
	PG_CATCH();
	{
		PyErr_SetPgError();
	}
	PG_END_TRY();

	RETURN_NONE_OR_NULL;
}

static PyObj
rollback(PyObj self)
{
	SavepointOperable(sp, PyPgSavepoint_FetchSTRING(self));
	PG_TRY();
	{
		RollbackToSavepoint(&sp);
		CommitTransactionCommand();
	}
	PG_CATCH();
	{
		PyErr_SetPgError();
	}
	PG_END_TRY();

	RETURN_NONE_OR_NULL;
}

static PyMethodDef PyPgSavepoint_Methods[] = {
	{"Commit", (PyCFunction) release, METH_NOARGS,
	"release the savepoint"},
	{"Abort", (PyCFunction) rollback, METH_NOARGS,
	"rollback to the savepoint"},
	{NULL}
};

static void
sp_dealloc(PyObj self)
{
	Py_DECREF(PyPgSavepoint_FetchString(self));
	self->ob_type->tp_free(self);
}

static PyObj
sp_repr(PyObj self)
{
	PyObj rob;
	rob = PyString_FromFormat("<Savepoint '%s'>",
				PyPgSavepoint_FetchSTRING(self));
	return(rob);
}

static PyObj
sp_str(PyObj self)
{
	PyObj rob;
	rob = PyPgSavepoint_FetchString(self);
	Py_INCREF(rob);
	return(rob);
}

static int
sp_init(PyObj self, PyObj args, PyObj kw)
{
	char *string = NULL;
	PyObj tb, str;

	tb = PyPgSavepoint_FetchTransaction(self);
	if (tb == NULL)
	{
		PyErr_SetString(PyExc_AttributeError,
			"savepoint class must specify '__xact__'");
		return(-1);
	}

	if (!PyArg_ParseTuple(args, "|s", &string))
		return(-1);

	if (string)
		str = PyString_FromString(string);
	else
		str = PyString_FromFormat("_pysp_%p_", self);
	PyPgSavepoint_FixString(self, str);

	PG_TRY();
	{
		DefineSavepoint(PyPgSavepoint_FetchSTRING(self));
		CommitTransactionCommand();
	}
	PG_CATCH();
	{
		PyErr_SetPgError();
	}
	PG_END_TRY();

	return(0);
}

static const char doc[] =
"Savepoint interface";

PyTypeObject PyPgSavepoint_Type = {
	PyObject_HEAD_INIT(NULL)
	0,										/* ob_size */
	"Postgres.Savepoint",			/* tp_name */
	sizeof(struct PyPgSavepoint),	/* tp_basicsize */
	0,										/* tp_itemsize */
	sp_dealloc,							/* tp_dealloc */
	NULL,									/* tp_print */
	NULL,									/* tp_getattr */
	NULL,									/* tp_setattr */
	NULL,									/* tp_compare */
	sp_repr,								/* tp_repr */
	NULL,									/* tp_as_number */
	NULL,									/* tp_as_sequence */
	NULL,									/* tp_as_mapping */
	NULL,									/* tp_hash */
	NULL,									/* tp_call */
	sp_str,								/* tp_str */
	NULL,									/* tp_getattro */
	NULL,									/* tp_setattro */
	NULL,									/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT |
	Py_TPFLAGS_BASETYPE,			   /* tp_flags */
	(char *) doc,						/* tp_doc */
	NULL,									/* tp_traverse */
	NULL,									/* tp_clear */
	NULL,									/* tp_richcompare */
	0,										/* tp_weaklistoffset */
	NULL,									/* tp_iter */
	NULL,									/* tp_iternext */
	PyPgSavepoint_Methods,			/* tp_methods */
	NULL,									/* tp_members */
	NULL,									/* tp_getset */
	NULL,									/* tp_base */
	NULL,									/* tp_dict */
	NULL,									/* tp_descr_get */
	NULL,									/* tp_descr_set */
	0,										/* tp_dictoffset */
	sp_init,								/* tp_init */
	NULL,									/* tp_alloc */
};
/*
 * vim: ts=3:sw=3:noet:
 */
