/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.collections;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMapImpl;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;

public interface EconomicMap<K, V>
extends UnmodifiableEconomicMap<K, V> {
    public V put(K var1, V var2);

    default public void putAll(EconomicMap<K, V> other) {
        UnmodifiableMapCursor e = other.getEntries();
        while (e.advance()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    default public void putAll(UnmodifiableEconomicMap<? extends K, ? extends V> other) {
        UnmodifiableMapCursor<K, V> entry = other.getEntries();
        while (entry.advance()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear();

    public V removeKey(K var1);

    @Override
    public MapCursor<K, V> getEntries();

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> var1);

    public static <K, V> EconomicMap<K, V> create() {
        return EconomicMap.create(Equivalence.DEFAULT);
    }

    public static <K, V> EconomicMap<K, V> create(int initialCapacity) {
        return EconomicMap.create(Equivalence.DEFAULT, initialCapacity);
    }

    public static <K, V> EconomicMap<K, V> create(Equivalence strategy) {
        return EconomicMapImpl.create(strategy, false);
    }

    public static <K, V> EconomicMap<K, V> create(UnmodifiableEconomicMap<K, V> m) {
        return EconomicMap.create(Equivalence.DEFAULT, m);
    }

    public static <K, V> EconomicMap<K, V> create(Equivalence strategy, UnmodifiableEconomicMap<K, V> m) {
        return EconomicMapImpl.create(strategy, m, false);
    }

    public static <K, V> EconomicMap<K, V> create(Equivalence strategy, int initialCapacity) {
        return EconomicMapImpl.create(strategy, initialCapacity, false);
    }

    public static <K, V> EconomicMap<K, V> wrapMap(final Map<K, V> map) {
        return new EconomicMap<K, V>(){

            @Override
            public V get(K key) {
                Object result = map.get(key);
                return result;
            }

            @Override
            public V put(K key, V value) {
                Object result = map.put(key, value);
                return result;
            }

            @Override
            public int size() {
                int result = map.size();
                return result;
            }

            @Override
            public boolean containsKey(K key) {
                return map.containsKey(key);
            }

            @Override
            public void clear() {
                map.clear();
            }

            @Override
            public V removeKey(K key) {
                Object result = map.remove(key);
                return result;
            }

            @Override
            public Iterable<V> getValues() {
                return map.values();
            }

            @Override
            public Iterable<K> getKeys() {
                return map.keySet();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public MapCursor<K, V> getEntries() {
                final Iterator iterator = map.entrySet().iterator();
                return new MapCursor<K, V>(){
                    private Map.Entry<K, V> current;

                    @Override
                    public boolean advance() {
                        boolean result = iterator.hasNext();
                        if (result) {
                            this.current = (Map.Entry)iterator.next();
                        }
                        return result;
                    }

                    @Override
                    public K getKey() {
                        return this.current.getKey();
                    }

                    @Override
                    public V getValue() {
                        return this.current.getValue();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
                map.replaceAll(function);
            }
        };
    }
}

