/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.Properties;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrackingFileManager {
    private Logger logger = NullLogger.INSTANCE;

    TrackingFileManager() {
    }

    public TrackingFileManager setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties read(File file) {
        String string = file.getAbsolutePath().intern();
        synchronized (string) {
            block8: {
                Properties properties;
                FileLock lock = null;
                FileChannel channel = null;
                try {
                    FileInputStream stream = new FileInputStream(file);
                    channel = stream.getChannel();
                    lock = channel.lock(0L, channel.size(), true);
                    Properties props = new Properties();
                    props.load(stream);
                    properties = props;
                    this.release(lock, file);
                    this.close(channel, file);
                }
                catch (FileNotFoundException e) {
                    this.release(lock, file);
                    this.close(channel, file);
                    break block8;
                    catch (IOException e2) {
                        try {
                            this.logger.debug("Failed to read resolution tracking file " + file, (Throwable)e2);
                            this.release(lock, file);
                            this.close(channel, file);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            this.release(lock, file);
                            this.close(channel, file);
                            throw throwable;
                        }
                    }
                }
                return properties;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(File file, Map<String, String> updates) {
        Properties props = new Properties();
        String string = file.getAbsolutePath().intern();
        synchronized (string) {
            File directory = file.getParentFile();
            if (!directory.exists() && !directory.mkdirs()) {
                this.logger.debug("Failed to create parent directories for resolution tracking file " + file);
                return props;
            }
            FileChannel channel = null;
            FileLock lock = null;
            try {
                channel = new RandomAccessFile(file, "rw").getChannel();
                lock = channel.lock(0L, channel.size(), false);
                if (file.canRead()) {
                    this.logger.debug("Reading resolution tracking file " + file);
                    ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
                    channel.read(buffer);
                    buffer.flip();
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer.array());
                    props.load(stream);
                }
                for (Map.Entry<String, String> update : updates.entrySet()) {
                    if (update.getValue() == null) {
                        props.remove(update.getKey());
                        continue;
                    }
                    props.setProperty(update.getKey(), update.getValue());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                this.logger.debug("Writing resolution tracking file " + file);
                props.store(stream, "NOTE: This is an internal implementation file, its format can be changed without prior notice.");
                byte[] data = stream.toByteArray();
                ByteBuffer buffer = ByteBuffer.allocate(data.length);
                buffer.put(data);
                buffer.flip();
                channel.position(0L);
                channel.write(buffer);
                this.release(lock, file);
                this.close(channel, file);
            }
            catch (IOException e) {
                try {
                    this.logger.debug("Failed to write resolution tracking file " + file, (Throwable)e);
                    this.release(lock, file);
                    this.close(channel, file);
                }
                catch (Throwable throwable) {
                    this.release(lock, file);
                    this.close(channel, file);
                    throw throwable;
                }
            }
        }
        return props;
    }

    private void release(FileLock lock, File file) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                this.logger.debug("Error releasing lock for resolution tracking file " + file, (Throwable)e);
            }
        }
    }

    private void close(FileChannel channel, File file) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                this.logger.debug("Error closing file channel for resolution tracking file " + file, (Throwable)e);
            }
        }
    }
}

