/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorGetNextValueNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import java.util.Set;

public abstract class IteratorGetNextValueNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    JavaScriptNode iteratorNode;
    @Node.Child
    private PropertyGetNode getValueNode;
    @Node.Child
    private PropertyGetNode getDoneNode;
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsJSObjectNode isObjectNode;
    @Node.Child
    private JavaScriptNode doneResultNode;
    @Node.Child
    private JSToBooleanNode toBooleanNode;
    private final boolean setDone;

    protected IteratorGetNextValueNode(JSContext context, JavaScriptNode iteratorNode, JavaScriptNode doneNode, boolean setDone) {
        this.iteratorNode = iteratorNode;
        this.getValueNode = PropertyGetNode.create("value", false, context);
        this.getDoneNode = PropertyGetNode.create("done", false, context);
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsJSObjectNode.create();
        this.toBooleanNode = JSToBooleanNode.create();
        this.doneResultNode = doneNode;
        this.setDone = setDone;
    }

    public static IteratorGetNextValueNode create(JSContext context, JavaScriptNode iterator, JavaScriptNode doneNode, boolean setDone) {
        return IteratorGetNextValueNodeGen.create(context, iterator, doneNode, setDone);
    }

    private Object iteratorNext(IteratorRecord iteratorRecord) {
        Object next = iteratorRecord.getNextMethod();
        DynamicObject iterator = iteratorRecord.getIterator();
        Object result = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, next));
        if (!this.isObjectNode.executeBoolean(result)) {
            throw Errors.createTypeErrorIterResultNotAnObject(result, this);
        }
        return result;
    }

    @Specialization
    protected Object iteratorStepAndGetValue(VirtualFrame frame, IteratorRecord iteratorRecord) {
        try {
            Object result = this.iteratorNext(iteratorRecord);
            boolean done = this.toBooleanNode.executeBoolean(this.getDoneNode.getValue(result));
            if (!done) {
                return this.getValueNode.getValue(result);
            }
            if (this.setDone) {
                iteratorRecord.setDone(true);
            }
            return this.doneResultNode.execute(frame);
        }
        catch (Exception ex) {
            if (this.setDone) {
                iteratorRecord.setDone(true);
            }
            throw ex;
        }
    }

    public abstract Object execute(VirtualFrame var1, IteratorRecord var2);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorGetNextValueNode.create(this.getValueNode.getContext(), IteratorGetNextValueNode.cloneUninitialized(this.iteratorNode, materializedTags), IteratorGetNextValueNode.cloneUninitialized(this.doneResultNode, materializedTags), this.setDone);
    }
}

